# Section presentation
 
The *Transactions preprocessing* section has the role to let you define how you want the transactions to be transformed before the association rule process.
 
![dku_app_transactions_preprocessing.png](awiBYGOYiZK0)
 
# Section interactions
 
## Columns identification
![dku_app_transactions_preprocessing_columns_identification.png](TXfhwbrkCZ0q)
 
You can here establish the mapping between your input transaction table schema and the columns used in the use case. Thus, you will have to set the below parameters :
- *Transaction identifier column*: This is the name of the column identifying each single transaction.
- *Items identifier column*: This is the name of the column identifying each item ([What do we mean by "item" ?](article:20)).
- *Transaction date column*: This is the name of the column flagging each transaction date.
- *Customers identified ?*: This is a boolean condition. The recommendation part of the **Market Basket Analysis** being optional, it however needs to have the customers identified within your transactions to be used. By validating this option you will then be invited to define which column identifies your customers.
  - *Customers identifier column*: This is the name of the column identifying each customer. It is only available if*Customers identified ?* is validated.
 
 
## Rules transactions dates filtering settings
 
![dates_filtering_strategy_settings.png](rWbIn0EssTd1)
 
You can here define your strategy to filter transaction dates taken into account to learn items association rules ([Learn more about those dates filtering strategies](article:62)).
 
 
## Dates format
 
![dates_format.png](YtAXwjHxZVFp)
 
We recommend the input transaction table to have its dates in a **[DSS non ambiguous dates format](https://doc.dataiku.com/dss/latest/preparation/dates.html#meanings-and-types)**(ISO-8601 or RFC 822). Dates respecting that format are considered *parsed dates*.
This menu will let you set if your transaction dates are already parsed. If this is not the case, you will have the ability to set the format your dates are stored so that DSS can handle their parsing.
 
 
## Items per transaction
 
![min_items_per_transaction.png](XWxaP2J34ToT)
 
Finally, this last menu lets you define the minimum quantity of items each transaction should contain to be taken into account in the association rule learning process. You could for for example need to have a focus on the highest transactions (in terms of item diversity).
 