# Webapp presentation

This webapp lets you analyze the support of your most frequent items.
It has different sections that will let you define your filtering strategy.

:warning: **Disclaimer**: On the pictures below, webapp works using the "Country" column as an *association rule scope* ([Learn more about this concept](article:51)). Your render will be slightly different (views on all your dataset and no "Rules scope" and "Focus on common items" sections) if you don't define a rule scope.

![items_frequency_analysis_with_rules_scope.png](rIT2KzFUVNCQ)


# Webapp helpers

The webapp has some helpers if you are not familiar with its wording.
![items_frequency_analysis_helpers.png](Gqs4QttxpZdP)
:arrow_up: :*Above, the first screenshot shows you the original state of the helper's section. Then, the second screenshot shows you what happens when you click on the "Get wording explanation" section: you can see the section has been unfolded and you now have the ability to click on some of the available sub-sections. Finally, the last screenshot shows that by clicking on the helper "What is an item?" you get some explanation about it.*.

# Rules scope (available only if some rules scopes are defined)

The *Rules scope* section lets you choose the rule scope on which you want to observe your most frequent items.
You can here choose one or many rules scopes to analyze. The picture below shows the effect of activating multiple rules scopes.

*NOTE*: If your **Market Basket Analysis** has been configured to work with an association rules scope, you won't see any results here before choosing at least one rule scope. ELSE, you won't see this section.

![rules_scope.png](hi3IK9Af2Tvo)
:arrow_up: :*Above, the first screenshot shows you the results get when only "Germany" is selected as a rule scope. You can see in red the most frequent items associated with this rule scope. Then the second screenshot shows you the results get when "Germany", "EIRE" and "France" are taken into account: you can now see that the bar chart is colored differently depending on the items belonging to rules scopes. When analyzing more than 1 rules scopes, items are sorted by decreasing average frequency.*

# Focus on common items (available only if some rules scopes are defined)

Since the purchasing patterns can vary depending on the rules scopes that you defined, it is likely some displayed items are not present in all the rules scopes (in the example used below, you can see that the product "POSTAGE" is present in rule scopes "France" and "Germany" but not in "EIRE". 
The *Focus on common items* option allows filtering the results only on the items that are common to at least 2 rule scopes and to increase this threshold if needed. 

*NOTE*: If your **Market Basket Analysis** has not been configured to work with an association rules scope,  you won't see this section.

![focus_on_common_items_with_rules_scope.png](EkTBhaqfk8aE)
:arrow_up: :*Above, the first screenshot shows you the results get for the 3 rules scopes "Germany", "EIRE" and "France"  when items are common to at least 2. scopes. Then the second screenshot shows you the results get when the number of common scopes per item is set to 3: now only items purchased in the 3 countries are displayed.*

# Focus on specific items

After getting your results, you may want to focus only on some of them: This is what this section is dedicated to.

![focus_on_specific_items.png](PMhpVut5kDcP)
:arrow_up: :*Above, the first screenshot shows you the results get for the 3 rules scopes "Germany", "EIRE" and "France". Then the second screenshot shows you the results get when doing a focus on the 3 items "POSTAGE", "CARRIAGE" and "REGENCY CAKESTAND 3 TIER"*.

# Max frequent items to analyze

This slider lets you define the number of items to display in the frequency analysis.

![max_frequent_items_to_analyze.png](vpSEWLc7bBY3)
:arrow_up: :*Above, the first screenshot shows you the results when analyzing the 20 most frequent items. Then, the second screenshot shows you the results get when analyzing the 40 most frequent items*.