# Webapp presentation

This webapp lets you choose your most frequent items to browse the association rules that are linked to them ([I don't remember what is an association rule](article:23)).

:warning: **Diclaimer 2**: On the pictures below, webapp works using the "Country" column as an *association rule scope* ([Learn more about this concept](article:51)). Your render will be slightly different (views on all your dataset and no "Rules scope" section) if you don't define a rule scope.

![rules_browser.png](CbZATPIdjcde)

# Webapp helpers
The webapp has some helpers if you are not familiar with its wording.

![rules_browser_helpers.png](mKzZJC81AveX)
:arrow_up: :*Above the first screenshot shows you the original state of the helpers' section. Then the second screenshot shows you what happens when you click on the "Get wording explanation" section: you can see the section has been unfolded and you now have the ability to click on some of the available sub-sections. Finally, the last screenshot shows that by clicking on the helper "What is an item?" you get some explanation about it.*.

# Search items

This menu allows you to select one or multiple items. Once you did your selection, you will be able to see the rules where the item(s) you chose are involved.

![rules_browser_search_items.png](7OjeiTKZ5uUp)
:arrow_up: :*Above, the first screenshot shows you how to interact with the menu where you will find the list of all the items involved in your Market Basket Analysis association rules. Then the second screenshot shows you what happens when you select some items. You can now see a result table with the rules linked to your item selection*.

**IMPORTANT:** In the resulting association rule table : 
- The column "Trigger" refers to the antecedent of the rules (since they are needed to *trigger* an association rule).
- The column "Outcome" refers to the consequent of the rules.

# Rules browsing strategy

The rules browsing strategy lets you choose how you want to analyze the rules linked to your item selection.
In effect, since association rules are a relationship between antecedent and consequent itemsets, you could be interested in : 
- Look at all the rules where your items are rule antecedents (or "TRIGGERS") <-> Find products you could recommend with your items selection. This is the default strategy of the application. To activate it, you will have to click on the "RULE TRIGGERS" button.
- Look at all the rules where your items are rule consequents (or "OUTCOMES") <-> Find products leading to the purchase of your items selection. To activate this strategy, you will have to click on the "RULE OUTCOMES" button.


![rules_browsing_strategy.png](5j6blmaFKKZ5)
:arrow_up: :*Above, screenshots show you an example of the results you get depending on the chosen dates filtering strategies. You can see on the first screenshot that with the "RULE TRIGGERS" browsing strategy, the chosen items appear in the "Trigger" column of the result table: thus you can see all the items that could be recommended with your selection in the "Outcome" column. Similarly, the second screenshot shows you that with the "RULE OUTCOMES" browsing strategy, the chosen items appear in the "Outcome" column: thus you can see all the items that could lead to the purchase of your selection*.


# CSV export

The "EXPORT CSV" button :arrow_down: will have the effect to download the displayed result table as a ".csv" file.

![export_csv.png](Uyq8jthEczmJ)


# Rules scope (available only if some rules scopes are defined)

The Rules scope section lets you choose the rule scope on which you want to filter the association rules results table. You can here choose one or many rules scopes to filter on. The default behavior of the application is to display all possible results when not any scope has been defined.

*NOTE*: If your **Market Basket Analysis** has not been configured to work with an association rules scope, you won't see this section.

![rules_browser_rules_scope.png](djQMb4UYiBDx)
:arrow_up: :*Above, screenshots show you the impact of filtering the result table with the rules scope menu. The first screenshot shows the entire result table displayed when no rules scope have been chosen (You can see multiple countries in the "Scope" column). The second screenshot shows you that after choosing "EIRE" as a rule scope, only rows linked to this country appear in the result table.*

# Filtering and sorting the result table

Finally, once you get your result table, you can use the filtering and sorting sections of the application. You will be able to:
- Define the minimum thresholds for each of the rule metrics ([what is a rule metric ?](article:11)) before displaying results. The default application behavior is to set all these thresholds to '0'.
- Define the columns used to order the result table and if results should be used in ascending order or not. The default application behavior is to sort the results by descending confidence.

![filtering_and_sorting_result_table.png](bNVRpmIo8gvG)
:arrow_up: :*Above, the screenshot shows a result table with a minimum frequency of 1.4%, a minimum confidence of 0.5, a minimum lift of 3 and a minimum conviction of 2. Then results are sorted by ascending conviction.*

