This solution has three main components: a Dataiku Application, two Code Verifying Web Apps, and a Model Metrics Dashboard.

* The **Dataiku Application** allows users to configure project connections, ingest the clinical note dataset into the data pipeline, and instantiate the web apps and dashboard.
* The two **Code Verifying Web Apps** support a human-in-the-loop process for reviewing, modifying, and committing the billing codes assigned by the model.
* The **Model Metrics Dashboard** provides an overview of the model's performance in medical code generation.

# Dataiku Application
To begin, the solution must be set up via the [Dataiku Application](article:19). This process ingests the clinical note file and prepares the pipeline to generate medical codes. The Dataiku Application is available on the **home page of Dataiku under the Applications section**.

Click the **CREATE APP INSTANCE** button to create a new application instance. It will create a new version of the parent project, which you can configure for your specific needs. For example, you can create multiple instances if you need to apply this solution to different datasets.

![dkapp-create-instance.png](ra1c6vcnXvIk)

## Connections Configuration
Configure the connections for the project datasets and the Code Editor Web App. Select the generative models to power the LLM mesh recipes. 
![dkapp-connection.png](p9jJlSPdi8Wb)

1. Select a connection or model for each item.
2.  Click the **RECONFIGURE** button.

## Upload Clinical Notes
Upload a CSV file containing your clinical notes. The file must contain the following columns: `patient_id`, `note_id`, `age`, `sex`, and `note`. Each row should represent a single clinician's note. Please read the [Data Model](article:14) to learn more about the required data schema.

![dkapp-ingestion.png](7ftoCxq5tyZm)

1. Upload your clinical note file.
2.  Click the **CHECK** button.

## Run Pipeline
This step processes your configurations and ingests the clinical notes into the pipeline to generate medical billing codes.

![dkapp-pipeline-built.png](oWLXudmMhMvj)

1. Click the **Generate** button to build the project Flow.

# Launch Web Apps
Launch the web apps to review, modify, and verify the billing codes for each clinical note.

![dkapp-launch-webapps.png](eKJwJD5cWyYR)

1. Click on **[Review & Verify Medical Codes](dashboard:L1Xe8ep)** to review, modify, and approve the model-assigned medical codes. 
 - Select the note_id in the top left corner to review the model-assigned medical codes. 
 - Modify the codes or concept domain and approve the results via the Code Editor webapp. 
 - Review the original note annotated with the associated clinical events. 
 - Commit the approved medical codes by clicking on the top left button  **COMMIT EDIT** .
![webapp-code-verification.png](BwmyrM5LLFzG)

2.  Click on **[Note Summary, Committed Codes, and Edit Log](dashboard:rhAqWdg)** to review notes with approved codes. This view includes a model-generated summary and a complete edit history.
![webapp-note-summary.png](AtizZJPsiDdB)
![webapp-verified-codes.png](sFYyPMZDm2c7)

# Model Metrics Dashboard
The dashboard displays a metrics panel for the data team to monitor model performance. It measures the quality of the generated medical codes by showing the ratio of valid, invalid, and missing codes among all extracted medical concepts. It also displays the distribution of the generated codes by diagnosis and procedure categories.

1.  Click on **[Model Accuracy & Code Distribution](dashboard:F0NPlNT)** to view the dashboard.
![dashboard-model-metrics.png](tWiTaBc5sitE)
![dashboard-code-distribution.png](ymxtRDyBV8yj)