The webapps [Review & Verify Medical Codes](dashboard:L1Xe8ep) and [Note Summary, Committed Codes, and Edit Log](dashboard:rhAqWdg) consist of three stand-alone webapps: [Code-Editor](web_app:U9RMBda), [note_viewer](web_app:snMNvjx), and [note_summary&validated_codes](web_app:w4Bejvc). 

# Review & Verify Medical Codes
![webapp-code-verification.png](zwWaXwDdRj0u)
This webapp contains a code editor and a note viewer to facilitate code auditing by clinical experts. It allows users to review, modify, and accept the model-assigned medical codes, assisted by the original text annotated with the associated clinical events for a given clinical note. 
Select the Note ID from the filter at the top left corner to display the results.

## Code Editor
The [Code Editor](web_app:U9RMBda) is powered by the VisualEdit Webapp. The following fields are editable:

| Column name         | Data type     | Description                                                                                                                                                                     |
|---------------------|---------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Concept type        | Linked record | There are four available values to select from the dropdown list: primary diagnosis, relevant diagnosis, major procedure or operation, relevant medical services and procedures |
| Mapped billing code | Linked record | The available biomedical vocabularies to select from the dropdown.                                                                                                              |
| Verified            | Boolean       | To accept a medical code for commit                                                                                                                                             |
| Comments            | Text          | To leave a comment                                                                                                                                                              |
![webapp-code-editor.png](Xas9y5DcnU05)

Please review the [VisualEdit Plug-in](https://dataiku.github.io/dss-visual-edit/install-plugin)  documentation for more information.

## Note Viewer
The [Note Viewer](web_app:snMNvjx) is a Dash Webapp that shows the original clinical note to assist in the code review. It displays the patient metadata and highlights the clinical note with the medical concepts and associated clinical events extracted by the model to help clinical experts locate critical events and identify related codes.

![webapp-note-viewer.png](uSRezzvpKDnm)

# Note Summary & Validated Codes
This webapp, supported by a single Dash Webapp [note_summary&validated_codes](web_app:w4Bejvc), shows the codes approved by the auditors. It displays the model-generated note summary and a table of verified medical codes. The table can be filtered by the concept type, and the highlighted cells represent the modified results, with a hover text displaying the edit log.

![webapp-note-summary.png](VkmAqZLLDG17)
![webapp-verified-codes.png](AFd2IXprtRUg)

