First, use the Dataiku Application to instantiate an instance of the Solution. It lets you ingest the clinical note file and prepare the pipeline to generate medical codes. The Dataiku Application is available on the **home page of Dataiku under the Applications section**.

Click the **CREATE APP INSTANCE** button to create a new application instance. This will create a new version of the parent project, which you can configure for your specific needs. For example, you can create multiple instances if you need to apply this Solution to different datasets.

![dkapp-create-instance.png](OMpSyVT66ggt)

# Ingest Clinical Notes
## Connections Configuration
Configure the connections for the project datasets and the Code Editor Web App. Select the generative models to power the LLM Mesh recipes.
![dkapp-connection.png](5Sqxt5VB1dvq)

1. Select a connection or model for each item.
2.  Click the **RECONFIGURE** button.

<div class="alert">
The Code Editor Web App requires an SQL connection to load the biomedical vocabularies. If a connection other than an SQL is selected, the web app may not correctly display the "Mapped billing code" column with the linked record.
</div>

<div class="alert">
You can assign different generative models for each LLM Mesh recipe. 
</div>

 **LLM Mesh recipes** 
| LLM Mesh Component                      | Object                                     | Description                                                                                                   | Required model                                                                                                                                                               |
|-----------------------------------------|-------------------------------------------------|---------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Prompt recipe: concept extraction       | [compute notes medical concepts all ](recipe:compute_notes_medical_concepts_all)             | Extract medical concepts and associated clinical events for each clinical note                                | A foundation model must have a context window large enough to contain both the input clinical note and the recipe prompt. Tested models: GPT4o, GPT4.1, Anthropic Claud 3.5. |
| Prompt recipe: note summarization       | [compute clinical notes summary ](recipe:compute_clinical_notes_summary)                 | Generate a succinct summary for healthcare providers for each clinical note                                   | A foundation model must have a context window large enough to contain both the input clinical note and the recipe prompt. Tested models: GPT4o, GPT4.1, Anthropic Claud 3.5. |
| Knowledge bank: medical code reference | [billing code standardized vocabularies embedded](recipe:compute_billing_code_standardized_vocabularies_embedded) | A knowledge bank embedded with the reference biomedical vocabularies, used by the CodeRag model              | An embedding model. Tested model: embedding v3 (OpenAI)                                                                                                                      |
| RAG: medical code mapping               | [CodeRag](saved_model:pRkYbMvN) (pRkYbMvN)                              | A RAG model used to map the most relevant medical code to a given concept and its associated clinical events. | A foundation model to propel the RAG. A smaller model should suffice to support this semantic search.                                                                                    |

## Upload Clinical Notes
Upload a CSV file containing your clinical notes. The file must include the following columns: `patient_id`, `note_id`, `age`, `sex`, and `note`. Each row should represent a single clinician's note. Please read the [Data Model](article:14) to learn more about the required data schema.

![dkapp-ingestion.png](GNghZENb779u)

1. Upload your clinical note file.
2.  Click the **CHECK** button.

## Run Pipeline
This step processes your configurations and ingests the clinical notes into the pipeline to generate medical billing codes.

![dkapp-pipeline-built.png](VADert0a0X4k)

1. Click the **Generate** button to build the project Flow.

# Launch Web Apps
Launch the web apps to review, modify, and verify the billing codes for each clinical note.

![dkapp-launch-webapps.png](r5alYGPsb8Sy)

1. Click on **[Review & Verify Medical Codes](dashboard:L1Xe8ep)** to review, modify, and approve the model-assigned medical codes. 
 - Select the note_id in the top left corner to review the model-assigned medical codes. 
 - Modify the codes or concept domain and approve the results via the Code Editor webapp. 
 - Review the original note with the associated clinical events. 
 - Commit the approved medical codes by clicking on the top left button  **COMMIT EDIT** .
![webapp-code-verification.png](Jdo3XxexoVAo)


2.  Click on **[Note Summary, Committed Codes, and Edit Log](dashboard:rhAqWdg)** to review notes with approved codes. This view includes a model-generated summary and a complete edit history.
![webapp-note-summary.png](CAWVz3eLc7Rf)
![webapp-verified-codes.png](O5wMJHYJMCzw)


# Launch Dashboard
Launch the model metrics dashboard to review model performance.

![dkapp-launch-dashboard.png](4OhGnR6w1BC8)


The dashboard displays a metrics panel for the data team to monitor model performance. It measures the quality of the generated medical codes by showing the ratio of valid, invalid, and missing codes among all extracted medical concepts. It also displays the distribution of the generated codes by diagnosis and procedure categories.

1.  Click on **[Model Accuracy & Code Distribution](dashboard:F0NPlNT)** to view the dashboard.
![dashboard-model-metrics.png](9d5qykbxEcKO)
![dashboard-code-distribution.png](OtMGqPe0TZd1)