import dataiku

from scenario_computation import run_what_if_exploration

# Read recipe inputs
input_prepared = dataiku.Dataset("input_prepared")
input_prepared_df = input_prepared.get_dataframe()


project = dataiku.api_client().get_default_project()
variables = project.get_variables()


#arg = ([30, 40], [-30, 30], [-30, 30], [-30, 30], [-30, 30],4000000,None, "none")

optimization_args = variables['standard']["optimization_args"]


df = run_what_if_exploration(
    ranges=optimization_args["ranges"],
    constraint_type=optimization_args["constraint_type"],
    target_roi=optimization_args["target_roi"],
    new_budget= optimization_args["new_budget"],
    gtol=0.0001,
)
optimization_results = dataiku.Dataset("optimization_results")

optimization_results.write_with_schema(df)