# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import json
import markdown2
import plotly
from dataiku import insights
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
df = dataiku.Dataset("LLM_output").get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
try:
    markdown_content = json.loads(df["llm_output"].item())['text']
except:
    markdown_content = df["llm_output"].item()

# Convert Markdown to HTML
html_body = markdown2.markdown(markdown_content)

# HTML Template with Custom CSS
html_content = f"""
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {{
            font-family: 'Inter', sans-serif;
            color: black;
        }}

        h1, h2, h3, h4, h5, h6 {{
            color: #3985ac;
        }}

        ul, ol {{
            color: black;
        }}

    </style>
</head>
<body>
    {html_body}
</body>
</html>
"""

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Save the content as a static insight
insights.save_data(id="LLM_Output", payload=html_content, content_type="text/html", label="Maintenance Performance AI Assistant")

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
dataiku.Dataset("report").write_with_schema(pd.DataFrame({"llm_report" : [html_content]}))