<span id="version" style="color: grey; float: right">Version 2.1.1</span>
# Maintenance Performance and Planning

Maintenance Planning and Performance is a solution designed to analyze past maintenance operations to reduce unplanned downtime and optimize maintenance plans for your equipment. By leveraging advanced analytical tools and Generative Artificial Intelligence (GenAI), this solution helps businesses address several challenges:

- **Maintenance issues emerge without notice**: Anticipate maintenance needs with a model-enriched approach fueled by historical maintenance data.
- **Understanding failure and service issues across various asset types is difficult**: Create model-powered root cause analyses by asset class to scale effectively across sites and machines.
- **Time-based Preventative Maintenance (PM) schedules lead to unnecessary maintenance**: Use predictive maintenance to estimate remaining useful life (RUL) and prioritize real maintenance needs.
- **Collaboration on effective maintenance planning across teams is challenging**: Utilize the collaborative features of Dataiku DSS and this solution to provide real-time insights across the value chain.

# Key Outcomes

## Overview of your maintenance KPIs

An immediate overview of key maintenance performance metrics: descriptive statistics on the number and type of maintenance operations, the ratio of unplanned vs. planned maintenance interventions, and comparisons to your target percentage.

![KPIs.png](PHqxu5r6gH8D)

## Forecasting your maintenance planning

A quick forecast of future maintenance needs and an estimation of the Remaining Useful Life (RUL) to prioritize equipment for maintenance.

![planning.png](VipgGJV9U0rV)

## Profiling your equipment and maintenance operations

A model of your equipment uptime to identify problematic profiles that show a pattern of early-life failures.

![profiles.png](OpzBcYZZUzJ2)

## Identifying and Interpreting the determinants of your maintenance performance using Generative Artificial Intelligence

A machine learning model developed in the Visual ML Lab that highlights the significant factors affecting your maintenance performance. Using large language models (LLM) in a simple agents' architecture in the Flow, the solution interprets these factors and generates an automatic report.

![llm.png](vUfmNDH0IjVI)