This section informs you about all the requirements needed to use this solution.

# Instance Requirements
This solution is only compatible with instances running **Dataiku V14+**.

# Code Environment
Project Python recipes use the code environment **solution_maintenance-performance-planning**.  
The Python version used is **3.9**.

Required packages for this code environment are:

>chromadb==0.5.5  
Flask==3.0.3  
Jinja2==3.1.4  
langchain==0.3.27
langchain-community==0.3.27
lifelines==0.28.0  
markdown2==2.5.0  
plotly_calplot==0.1.20  
pysqlite3-binary==0.5.4
scikit-learn>=1.0,<1.1  

# Plugins Requirements

You will need to install the following on your DSS instance:  
- [Dataiku's Survival Analysis Plugin](https://www.dataiku.com/product/plugins/survival-analysis/).

## Installing a DSS Plugin
[Learn how to install a DSS plugin](https://doc.dataiku.com/dss/latest/plugins/installing.html).

# LLM Mesh Connection
This solution uses [Dataiku's LLM Mesh](https://doc.dataiku.com/dss/latest/generative-ai/introduction.html) to interact with local or remote models. Connections to LLM services need to be configured in **Administration > Connections**:

![llm_mesh.png](TN2vOqGI4n7F)

In particular, you will need access to models able to embed your documents and provide LLM prompt services:

1. **Embedding Documents**: To embed the documents into the Knowledge Bank, an LLM connection needs to be set up in the Knowledge Bank settings:  
   ![knowledge_bank.png](kkjMtFNjTtCo)

2. **Querying the Knowledge Bank**: You will need to create an Augmented LLM. Click on **Add an Augmented LLM** in the Core tab of the Knowledge Bank and select the LLM connection you established beforehand:  
   ![augmented.png](FWJiSnIQQ6Zx)

3. **First LLM Prompt Recipe**: Choose this Augmented LLM in the first LLM Prompt Recipe of the flow:  
   ![retrieval_llm.png](2k31m39fWfgd)  
   As a result, the Flow now links the Knowledge Bank and the first LLM Prompt recipe:  
   ![generative-AI.png](8HPtQBIaDN2q)

4. **Second LLM Prompt Recipe**: Finally, choose the LLM connection for the second LLM Prompt recipe, which will summarize and produce the automatic report. This is a single call for the entire run, and the quality of the report is highly dependent on its performance. Therefore, this is where you would want to use the best LLM possible:  
   ![last_llm.png](Smi4LPbXTXa3)