# -*- coding: utf-8 -*-
import dataiku

# Library functions
# ==========================================================================================================================
from public_database_access import chembl_database_error_test, pubchem_database_error_test, fetch_amino_acid_sequence

#Use in-memory SQLite database for cache
#chembl = new_client(cache=False, cache_filepath=":memory:")

# Retrieve dataiku variables from user specifications
# ============================================================================================
target_accession = dataiku.get_custom_variables()['accession_protein_code']
database =  dataiku.get_custom_variables()["database"]

# Use library functions to validate the target protein code and parse the parameters from the database query
# ============================================================================================
if database == 'Chembl':
    molecules_info_df, metadata_info_df = chembl_database_error_test(target_accession)
    metadata_info_df['database'] = database
elif database == 'PubChem':
    molecules_info_df, metadata_info_df = pubchem_database_error_test(target_accession)
    metadata_info_df['database'] = database
else:
    raise ValueError("Invalid database. Please provide either 'Chembl' or 'PubChem'.")
amino_acid_sequence = fetch_amino_acid_sequence(target_accession)
metadata_info_df['amino_acid_seq'] = amino_acid_sequence

# Write recipe outputs
# ============================================================================================
molecules = dataiku.Dataset("molecules")
molecules.write_with_schema(molecules_info_df)

# Write recipe outputs
# ============================================================================================
metadata = dataiku.Dataset("metadata")
metadata.write_with_schema(metadata_info_df)
