<span id="version" style="color: grey; float: right">Version 1.1.0</span>

The realm of  **drug discovery**  emerges as a dynamic space where scientific advancement intersects with the imperative to overcome medical challenges. Exploring new drugs to improve human health is a significant effort that requires collaboration among scientists, clinicians, and regulatory authorities to bring new treatments to patients. The drug discovery process involves identifying a target protein related to a specific disease, finding or designing molecules that interact with that protein in a desired way, testing these molecules rigorously, and, if successful, developing them into safe and effective drugs for treating the disease. It is a complex and time consuming process that  **can cost around $2.6 billion and take about 12 years on average**. AI can play a pivotal role in  optimizing the drug discovery process by pinpointing the most favorable drug candidates prior to commencing.

# Business Value
In recent years, the field of drug discovery has undergone a substantial transformation through the integration of artificial intelligence (AI). AI-enabled drug discovery has leveraged technological progress, including the utilization of neural networks for molecule design and the application of knowledge graphs to decipher target biology. Notably, the investment in AI-enabled drug development has experienced a remarkable surge, reaching $59.3 billion in total as of March 2023, a nearly 27-fold increase since 2015. (Source: Deep Pharma Intelligence). Analysts project that a reduction of 20% to 40% in preclinical development costs could provide the financial resources required to successfully advance four to eight novel molecules. Biotech companies embracing an AI-driven approach have cultivated an impressive pipeline of potential drugs. Boasting over 150 small-molecule drugs in the discovery phase and 15 undergoing clinical trials, the transformative role of AI in drug discovery becomes undeniable. 

# Solution Scope
This solution aims to **optimize the process of molecular screening**  on selected target proteins. We leverage machine learning to predict molecular properties from chemical structures and guide the digital drug discovery process by identifying the most promising drug candidates before experimental work is conducted. 

 #  Value Proposition
 1. Query molecules (SMILES) with known bioactivity for a specific protein target via ChEMBL or PubChem API to predict bioactivity.
 2. Generate molecular descriptors and fingerprints to perform quantitative structure-activity analysis and understand how molecular properties influence bioactivity.
  ![dashboard2.png](j7zjgatQ4jt4)
 3. Train and benchmark machine learning models to predict molecular bioactivity (pIC50) as a measure of molecule potency and molecular toxicity for safety to speed up experimental work on large datasets.
 4. Score novel molecules and prioritize the ones that qualify for the next discovery stage under the required properties.
![dashboard3.png](u3Oe66Yg6LG9)
 5. Assess further compound similarity using t-SNE and statistics that help to identify structurally related studied compounds to validate potential drug targets.
 6. Publish the results to a template dashboard that showcases the analysis, modeling, and novel molecule output. 
 
 ![sol_img.png](fiq7qqjxhibM)


