| Fingerprint Descriptor (Featurizer) | Explanation | Solution Variable Name
| ------------------ | ------------ | 
|  **Molecular ACCess System (MACCS) keys** | Binary substructure key-based fingerprint which uses 166 predefined keys. | ```MACCS```
| **ECFP fingerprints based on Morgan algorithm**  |  ECFP binary fingerprints use a radius of 2 to define the circular neighborhood surrounding each atom. |  ```ecfp```
| **Mordred**  |Continuous descriptors with more than 1800 2D and 3D descriptors. | ```mordred```
| **ChemBERTa (PubChem fingerprints)** | Learned representations from a pre-trained SMILES transformer model. This featurizer is available through HuggingFace open source models using their transformer Python package, which is embedded in molfeat’s ‘PretrainedHFTransformer’ class. | ```ChemBERTa```


**Example: MACCS (Molecular ACCess System)**  keys are a set of binary fingerprints that encode the presence or absence of specific chemical substructures or features in a molecule. These substructures are designed to capture important functional groups, ring systems, and other structural characteristics. Each bit in the MACCS key fingerprint corresponds to the presence (1) or absence (0) of a particular substructure. The MACCS keys consist of 166 different structural keys, each representing a specific substructure or property. Here are a few examples of MACCS keys and the substructures they represent:
- MACCS Key 1: Hydrogen Bond Donor (1 bit)
This key indicates whether a molecule has a hydrogen atom that can act as a donor in hydrogen bonding.
- MACCS Key 15: Aromatic Carbon (1 bit)
This key is set if the molecule has a carbon atom that is part of an aromatic ring system.
- MACCS Key 42: Aliphatic Carbon Attached to Heteroatom (1 bit)
This key is set if the molecule contains an aliphatic (non-aromatic) carbon atom bonded to a heteroatom (e.g., oxygen or nitrogen).
- MACCS Key 123: 3-Membered Heteroatom Ring (1 bit)
This key is set if the molecule contains a 3-membered ring with at least one heteroatom.
- MACCS Key 166: Tetrazole Ring (1 bit)
This key is set if the molecule contains a tetrazole ring, which is a five-membered ring containing four nitrogen atoms and one carbon atom.
