This section details all the requirements needed to use this solution.

## Instance Requirements
This solution is compatible with **Dataiku 13.4+**

## Code Environment
Project python recipes uses the code env **solution_molecular-prop-prediction**.


Required packages for this code env are: 
>Flask
PubChemPy
chembl-webresource-client
datamol
deepchem
huggingface-hub
molfeat
python-dotenv
rdkit
requests
tqdm
transformers

## Base imports
from dataiku.code_env_resources import clear_all_env_vars
from dataiku.code_env_resources import set_env_path
from dataiku.code_env_resources import set_env_var
from dataiku.code_env_resources import grant_permissions
from transformers import AutoTokenizer, AutoModel

# Clears all environment variables defined by previously run script
clear_all_env_vars()

## Hugging Face
# Set HuggingFace cache directory
set_env_path("TRANSFORMERS_CACHE", "huggingface")

tokenizer = AutoTokenizer.from_pretrained("DeepChem/ChemBERTa-77M-MLM", cache_dir="huggingface")
model = AutoModel.from_pretrained("DeepChem/ChemBERTa-77M-MLM", cache_dir="huggingface")

grant_permissions("huggingface")
```

## Package License Information

| Python Package | Python | License
| ------------------ | ------------ | 
| [chembl-webresource-client](https://github.com/chembl/chembl_webresource_client) | 3.7 - 3.9 | OSI Approved :: Apache Software License
|  [datamol](https://docs.datamol.io/stable/) | 3.8 - 3.11 |  Apache-2.0
|  [molfeat](https://pypi.org/project/molfeat/)  |3.8 - 3. 10  | Apache-2.0
| [rdkit](https://pypi.org/project/rdkit/) | 3.7 - 3.11 | BSD 3-Clause
|[huggingface-hub](https://pypi.org/project/huggingface-hub/) | 3.8 - 3.11 | [Licenses](https://huggingface.co/docs/hub/repositories-licenses)
| [tqdm](https://pypi.org/project/tqdm/)  | 3.7 - 3.11 | MIT
|[transformers](https://pypi.org/project/transformers/) |3.8 - 3.10 | Apache-2.0
| [python-dotenv](https://pypi.org/project/python-dotenv/) | 3.10 - 3.12 | BSD OSI
| [deepchem](https://github.com/deepchem/deepchem/blob/master/LICENSE) | 3.7 - 3.10 | MIT



