<span id="version" style="color: grey; float: right">v.1.0.0</span>
# Manufacturing Process Control
Optimizing manufacturing processes for quality, yield, or efficiency requires the validation of new parameter settings, typically using Statistical Process Control (SPC) methods. The Manufacturing Process Control Solution empowers Process and Quality Engineers to do exactly this in a no-code Dataiku Application. Users can automatically generate control charts to assess process stability and calculate key capability indices (Cp, Cpk, Cpm, Cpmk) to verify that parameters will remain within specification limits and meet quality requirements. 

Validating new parameters with SPC can be a cumbersome undertaking; engineers typically move trial run data from their data collection environment, to a data preparation tool, to a specialized SPC software. Furthermore another tool may be used to calculate or determine the new improved parameter settings. Combined with the Manufacturing Process Control Solution, Dataiku provides a single environment for doing all of these steps.

# Key Outcomes
 **1. Control Charts** 
Generate classical control charts, such as X-bar and R charts, to visually monitor the stability of process parameters and key target metrics. These charts help determine if a manufacturing process is under statistical control and identify any special cause variations that signal instability.
![control_charts_dashboard_1.png](sWqkYGJrp6rR)

**2. Automated Capability Study and Reporting**
For processes determined to be stable, the Solution automatically calculates key capability indices (Cp, Cpk, Cpm, Cpmk) and presents them in a comprehensive summary. The report includes histograms showing the data distribution against specification limits and a translation chart that contextualizes the Cpk score with its corresponding sigma level and defect rate.
![control_charts_dashboard_2.png](kjxu9jsXub54)
