To work with this Solution, **DO NOT USE THE PROJECT ITSELF** but the [Dataiku Application](https://doc.dataiku.com/dss/latest/applications/index.html) that comes with it.  
After installation, this application can be found on the **Dataiku home page in the Applications section.**  
It will help you connect your data, define your parameters, and launch the SPC analysis.

Create a new Dataiku Application by clicking the **CREATE APP INSTANCE** button. This will create a new instance of the parent project. You can create as many instances as you need (for example, if you want to apply this Solution to multiple datasets).


---

## Step 1 – Data sources
![data_sources_section.png](GVcMmCUSBFvx)
You first need to provide the data to be analyzed. Two options are available:

- **Option 1 – Data upload**: Drag and drop your files directly into the interface. Multiple files are supported, but they must share the same schema. Once uploaded, click **Upload** to register the dataset.  
- **Option 2 – Data connection**: Instead of uploading a file, you can connect to an existing dataset in one of your Dataiku projects. Simply select the project and the dataset from the dropdown list.  

⚠️ Choose only one option. If you upload files from your computer, skip the database connection section.  

If you want to extract information from a saved study of Parameters Analyzer, check the box **I’m using Parameters Analyzer** and select your Parameters Analyzer instance and saved study before moving to the next step.

---

## Step 2 – Columns mapping
![column mapping section.png](0vjACWzxPcdz)
Once your dataset is connected, you need to configure which columns will be analyzed:

1. **Select date column**  
   Choose the time or date column in your dataset. This is required for chronological analysis.  

2. **Select variables to analyze**  
   Pick the variables you want to include in the SPC charts. You can add multiple variables, and they will all appear in the analysis.  

3. **Define optional limits and targets**  
   For each selected variable, you can optionally enter:  
   - **LSL (Lower Specification Limit)**  
   - **USL (Upper Specification Limit)**  
   - **Target Value** (e.g. set point)  

   ⚠️ Note: Capability metrics (Cp, Cpk, Cpm, Cpkm) can only be calculated if USL and LSL are both provided. Cpm and Cpkm also require a target value to be provided.  

4. **Set subgroup size**  
   The subgroup size defines how many data points are grouped together in the Xbar-R charts. A size between 2 and 10 is recommended for reliable results. (note that the future version of this Solution will also provide I-R and Xbar-S charts, which are typically recommended for subgroup sizes of 1 and 10+, respectively.

5. **Run capability study**  
   Once everything is set, click **Run Now** to generate the SPC charts and metrics. You can also access additional run details or directly open the dashboard to visualize results.  

---

## Step 3 – View results

After running the study, click **View Dashboard** to explore your SPC charts.  
The dashboard will show:  

- Xbar-R control charts for the selected variables.  
- Capability metrics (if limits were provided).  
- Distribution of measurements against the specification limits and targets.  

More details on the dashboard in the[ dedicated article](article:7)