# Data Sources Requirements

In this Solution, a single dataset is required: the **experiment dataset**.  
This dataset contains process data that will be used to generate the SPC charts.  While any numerical data can be input, the assumption is that this dataset contains measurements from specifcally configured process, e.g. an experimental process run for which some parameters where given new set points. Although not a requirement, it is highly recommended that this dataset has an appropriate length for a capability study, to allow for proper calculations and useful visualization. 

Assumption (for v1.1.0):
- If data is continuous, it contains regularly spaced time series
- If data is event-based, it can be divided into equaly sized sub-groups

Optionally, you can connect this Solution to the **Parameters Analyzer** Dataiku Solution. In this case, the saved study created in Parameters Analyzer will be connected to the instance and used to pre-fill specification limits into the columns mapping table.

---

## Experiment Dataset (Mandatory)

This dataset must include:

- A **date column** (_date/time_): The reference time variable used for chronological ordering of process measurements.  
- One or more **variables to analyze** (_float/integer_): The process measurements for which SPC charts will be created.  

**[Experiment Dataset schema](dataset:uploaded_experiment_dataset-1)** Example

- `date_time` (_date/time_)): Timestamp of the measurement.  
- `T_data_1` (_float/integer_): Example process measurement.  
- `T_data_2` (_float/integer_): Example process measurement.  
- `quality` (_float/integer_): Example process measurement.  

Notes:
- The dataset must contain at least one **parsed datetime column**.  
- Any number of process variables can be included and later selected in the application. 
- Ability for including  **categorical values**  is planned for a future version of the Solution.

Example schema:

| date_time           | T_data_1 | T_data_2 | quality |
|---------------------|----------|----------|---------|
| 2025-01-01 08:00:00 | 475.0    | 12.3     | 421      |
| 2025-01-01 09:00:00 | 482.1    | 11.8     | 432     |
| 2025-01-01 10:00:00 | 478.5    | 12.0     | 426      |

---

## Optional Specification Limits

When running the analysis, you can optionally enter **specification limits** and a **target value** for each variable directly in the application interface:

- **LSL (Lower Specification Limit)**  
- **USL (Upper Specification Limit)**  
- **Target Value** (set point)

Notes:
- If **LSL and USL** are provided, capability metrics (Cp, Cpk) can be calculated.  
- If a **Target Value** is also provided, additional metrics (Cpm, Cpkm) become available.  
- If no limits are defined, control charts will still be generated, but metrics will not be calculated.  

---

## Parameters Analyzer Connection (Optional)

If you choose to connect this Solution to **Parameters Analyzer**, information is automatically extracted from the selected **saved study** and used to pre-configure the application. This includes:  

- The **date variable** used in the study  
- The **selected variables** to analyze  
- The **specification limits** (LSL, USL) and **target values** defined in Parameters Analyzer  

⚠️ It is required that the names of the  **columns selected**  for the SPC analysis  **match**  the column names in the Parameters Analyzer  **saved study** . If they don't match, the pre-configuration will fail.