To configure and run the process, we will follow the steps as in the [Dataiku Application Configuration](article:6) section. Since you are going through the case study, we assume you have already accessed the application and created an instance, so this step is skipped in the walkthrough. In case not, please refer to the above mentioned section for instructions. 

## Data Sources Section
There are two options for connecting data sources: Option 1 – Data upload and Option 2 - Data connection. 

For the case study, we will be using Option 1. However, you do not need to select data, as we will be using the case study dataset which is pre-loaded ("uploaded_experimenet_dataset.csv")
![control_charts_pre-loaded_dataset.png](Wlc7ptUnp6ZS)

Simply click "UPLOAD", in the Option 1 box.

This solution can OPTIONALLY import certain data from saved studies of [Parameters Analyzer](https://knowledge.dataiku.com/latest/solutions/manufacturing-energy/solution-parameters-analyzer.html). Specifically, the following information can be imported and used to prefill a later step in the Control Charts solution:
 - parameters to include in the capability study
 - the upper and lower bounds for each parameter in the saved study is imported as the upper- and lower specification limits for the capability study for each respective parameter
 - the OK/NOK value for the target parameter is imported as the target value for the target parameter, to calculate Cpm and Cpmk.

For the case study we will not be using this functionality, although there will still be prefilled data in the next section, for sake of time.

## Columns Mapping Section
Since in this case study we have pre-loaded data, simply click "REFRESH" to have the values appear in the columns mapping table. (Normally you would need to enter this manually). The table should appear with the values as shown below:
![control_charts_columns_mapping.png](rD19LPC9N9vf)

We select chart type X̅-R and define a subgroup size of 5. Proceed and run the application by selecting "RUN NOW". 

## View Dashboards
Finally, select "VIEW DASHBOARD"

### First Dashboard - Control Charts
This dashboard contains Xbar and R control charts for the parameters you selected. 
![control_charts_dashboard_1.png](9a7Mi5LYBihs)

Evaluating the control charts, we see that the target parameter ```quality``` is in control, as well as the first temperature parameter ```T_data_1_1```. We see that ```T_data_2_1``` has very minor special cause variation in both its X̅ and R charts. And we see that ```T_data_3_1``` has slight special cause variation in its R chart.

### Second Dashboard - Capability Metrics
This dashboard contains:
 1. Capability metrics for each selected parameter. NOTE: metrics are only calculated if the parameter is under statistical control, as indicated by the control charts on the previous page. Parameter is considered out of control if any subgroup is beyond the control limits.
 2. Distribution plot for each parameter, of the data collected in the experiment. If upper/lower specification limits (USL/LSL) or a target were defined, these are also indicated in the plot. The distribution plot is overlaid with a normal distribution curve, for reference. NOTE: depending on how many data points are included in the dataset, the normal distribution curve may be irregular.
 3. Table of Cpk values and equivalent statistics to help interpret the metrics.

On this dashboard we see the capability metrics for the parameters that were determined to be under statistical control. Note that for ```T_data_1_1``` Cpm and Cpkm metrics are calculated, since we also defined a target value for this parameter (unlike for the ```quality``` parameter).
![control_charts_dashboard_2.png](PQ4seIPpzlKh)

With these results we could now proceed to more closely investigate whether the special cause variation in ```T_data_2_1``` and ```T_data_3_1``` can be avoided. We would likely first have a discussion with quality and process teams to discuss whether the capability of the process is sufficient as is though, since the outliers in those two parameters are quite minor, and because the target value ```quality``` is in control. The dashboards generated in this solution would provide a valuable quantitative basis on which to have such a discussion.

# Conclusion
The Control Charts solution provides a streamlined, no-code experience for Process and Quality Engineers to accelerate the validation of parameter settings. By automatically generating control charts and capability metrics, it empowers users to confidently and quickly verify if process changes lead to a stable, reliable process that still meets specifications. This help ensure theoretical improvements translate to tangible gains in quality, yield, and efficiency on the factory floor.