## 1. Sales Deviation
Ingesting an analytics-enabled omnichannel commercial model in pharmaceutical organizations may significantly impact **marketing efficiencies and cost savings**. Building and managing an omnichannel strategy has become more complex due to the increasing communication channel options pushed by digital innovation. Moreover, such systems require analytics talents, scalable infrastructure, and frequent updates to keep up with new channels and HCP-changing behaviors. This solution aims to assist healthcare organizations in **tracking the sales of their products** by analyzing relevant product transactions and marketing actions. To identify the optimal balance between marketing efforts and user actions, we use descriptive analytics and display marketing and sales insights by brand.
To understand the **relationship between marketing outreach and sales**, we need to look at the **change in sales after a given outreach behavior** occurs. This means the effect of a marketing campaign in week 1 can only be seen on sales in the following weeks - in a different week than the outreach occurs. To associate future sales with a given week’s marketing campaign, we use a window recipe to create a frame that groups sales by account_id and product_id. Then in the ‘aggregations’ tab, we use the Lead operation to associate future sales with a given week (X - specified by the user) of marketing activities. By comparing the sales of the current and the lead week, we generate a  **multiclass**  feature ```sales_devition``` that takes values;  **increase, decrease, and constant**  if the change in sales is within a user-defined threshold (+- Y percent). We then employ machine learning algorithms to understand which are the features that drive these changes to focus the marketing effort and investments. 

## 2. Brand Adoption
Brand adoption in the pharmaceutical industry refers to the process by which healthcare professionals and patients accept and incorporate a particular brand of medication into their clinical practice or treatment regimen. It measures the extent to which a pharmaceutical brand is utilized and preferred by healthcare providers and patients over other available options. Brand adoption is influenced by various factors, including the efficacy and safety of the medication, its unique features or advantages compared to other alternatives, the reputation and trustworthiness of the pharmaceutical company, **marketing and promotional activities, and healthcare professionals’ personal experiences and preferences**. Pharmaceutical companies strive to achieve high brand adoption rates for their medications as it directly impacts market share, revenue, and overall success. In this solution, we use the transaction data to generate a binary ```brand_adoption``` feature on whether a HealthCare Provider has “adopted” (purchased/prescribed) a product before or not. We aggregate the data (all the weekly transactions and communication channel metrics) by HCP and form a  **classification**  problem. A machine learning algorithm is trained on historical user characteristics (Providers dataset) and marketing (Omnichannel dataset) interactions and enable users to score new data with the same features. We further extract feature importance and individual feature values for each account ID to explain which factors impact (positively or negatively) the probability of adoption through visual displays. 


