## **Machine Learning Algorithms:** 
For both problems we utilize **Gradient Boosting** ensemble learning algorithms that combine multiple decision trees to make predictions. They work by building initial weak prediction models and then train subsequent models to correct mistakes by previous iterations and make accurate predictions.  Gradient Boosting algorithms, such as  **XGBoost**  or  **LightGBM** , often perform well on imbalanced datasets by assigning higher weights to minority class samples or using class-specific hyperparameters. They are designed to be fast, efficient, and scalable with handling large datasets, missing values and incorporating regularization techniques.
 
## **Metrics:** 
ROC AUC metric provides a measure of how well a model can distinguish between the positive and negative classes.
 
 ## **Explainability Features:**
- **Feature Importance**: shows the relative contribution of each feature to the model. A higher value indicates more times the nodes split on the feature. The algorithm assumes that the more influential the feature is for generating a prediction, the more times it is split.
- **What-if analysis** allows both technical users and business experts to test different combinations of inputs and review if specific changes would yield different outcomes. For example, users can adjust the communication channel attempt and evaluate whether changing the specific marketing activities, impacts the percentage of the expected increase or decrease of sales in the following weeks and take action accordingly.
- **SHAP (SHapley Additive exPlanations)** values measure the contribution of each feature towards the difference between the expected prediction (e.g., the average prediction across all instances) and the prediction for a specific instance. Positive SHAP values indicate that the presence of a feature increases the prediction relative to the expected value, while negative values imply a decrease in the prediction. The magnitude of the SHAP value represents the extent of the contribution. 

