# Case Study: Optimizing HCP Engagement with Data-Driven Omnichannel Marketing

This case study offers a walkthrough of the solution using synthesized marketing data.

# Company Background
NeuroPharm Solutions, a mid-sized pharmaceutical company, specializes in developing innovative treatments for neurological conditions. One of their flagship medications, LiliVan™, is designed to manage symptoms of epilepsy and is targeted toward neurologists and other specialists in neurology. However, LiliVan™ has yet to achieve its anticipated market penetration, and NeuroPharm is looking to refine its marketing strategy to enhance healthcare provider (HCP) engagement and drive adoption among targeted specialists. With increasing competition and a shift toward digital-first healthcare communications, NeuroPharm aims to implement a comprehensive omnichannel strategy. This approach will enable them to deliver tailored, data-driven communications that align with each HCP’s preferences, ensuring more impactful interactions and stronger brand adoption.

# Initial Situation
- Use of diverse marketing channels with unclear impact on sales
- Lack of personalization slows adoption and increases cost of unecessary resource allocation

# Data
Data sources from CRM systems, google analytics, HCP profiles and other:
- Healthcare Provider Characteristics: HCP profiles, including demographics, specialties, and mail preferences.
- Marketing Activity Data: Records of various interactions with HCPs, categorized by channel type (e.g., email, in-person, digital) and reach and response.
- Sales Data: Sales performance for different products.
- Product and Brand Information: Product details and price.

# Goal
NeuroPharm’s primary objective is to boost the market adoption of LiliVan™ by building stronger, data-driven connections with neurologists and other targeted HCPs.

- Identifying the relationship between marketing spend and sales impact to refine budget distribution across channels.
- Understanding which channels and strategies most effectively drive HCP engagement and product adoption.
- Estimating the probability of brand adoption by individual HCPs to prioritize marketing resources effectively.

# Insights
The Dataiku solution surfaces actionable insights through a series of analytical outputs:

Marketing teams can view sales and engagement trends segmented by HCP, hospital, and product.
First of all it is interesting to check how sales vary over time for the product of interest and what is the overall revenue under the current campaing within hospitals.
![1.png](P7CZwuNHADM5)
![2.png](SQh8GWtuzR5J)

To check channel engagements at a granular level, the multichannel graph below reveleas individual engagement by week. 
![3.png](eOGXHsEWbrGF)

Interestingly, the pivot table revealed that this drug currently does not generate revenue from hospital neurologists, and it is definitely worth trying to promote it to that group of HCPs. 

![4.png](Qf7zl7pF0MMh)

Setting as the target group neurologists and choosing webcall as a medium cost communication channel they decided to investigate communication patterns for neurologists in clinics for this particular drug to get a better indication of channel combinations and revenue relation. It seems that the combination of a successful call, phone call, and some website activity (in no particular order) is linked to higher revenue activity, and they decided to reach out to this group of HCPs through this channel while boosting online ads. 

![5.png](YO4VXosBaMJA)

Moreover, to understand the relationship between marketing outreach and sales, they need to look at the change in sales after a given outreach behavior occurs. Using historical data – sales, marketing, the HCP characteristics, and machine learning algorithms, they classify the expected sales in X weeks into Increase, Decrease, and Constant. The results below show that account tenure and more website activity impact the sales changes. 

![6.png](9dJs4xaZNHO6)

Moreover, another classification model estimates the likelihood of HCPs adopting this specific brand based on past sales. The marketing team prioritized neurologists in hospitals who purchased Beveran medication under the same family of drugs. Hence, this is a good target group for promoting Lilivan. Below, they used the model to score this target group based on historical communication and characteristics to reach out first to accounts of the high likelihood of adoption. The individual profiles and communication analysis for other products can help personalize the outreach methods and decide whether it is worth investing in sales reps as expensive resources. 

![7.png](0VdaHoY49umP)
![8.png](xZGh70Z69EOW)

# Business Impact
By implementing Dataiku’s solution, NeuroPharm  gain a comprehensive toolkit to improve their omnichannel marketing effectiveness:
- Data-driven insights into neurology specialists communication preferences for channel combination and prioritization.
- Better understanding of factors driving Lilivan sales for better resource allocation to boost lower engagement through relevant channels. 
- Addressed the right target audience with high potential of brand adoption for prioritization of sales reporisentatives. 
- implemented a flexible framework that allows to continuously update as healthcare communication methods and HCP preferences evolve.

# Conclusion
By implementing the Dataiku omnichannel solution, NeuroPharm has transformed its approach to marketing LiliVan™, moving from a generalized strategy to a targeted, data-driven model. The solution’s combination of integrated data, machine learning insights, and predictive analytics has empowered NeuroPharm to optimize its marketing spend, engage HCPs on their preferred channels, and strategically allocate resources toward high-potential accounts. This not only accelerates brand adoption but also solidifies NeuroPharm’s position as an adaptable, innovative player in the neurology market. With this scalable framework, NeuroPharm is well-positioned to meet evolving HCP needs and drive continued success for LiliVan™.
