# Introduction to the overmolding process

This solution comes with pre-loaded datasets dealing with overmolding in toothbrush manufacturing. It’s a process of injection of silicone on the toothbrush handle, resulting in a seamless combination of plastic and rubber touch for better handling.
![toothbrush.png](tbgLwlgJvhTJ)

<br>
First, the initial material, sometimes referred to as the substrate, has already been injected during a previous step and the toothbrushes are automatically fed to the machine :

![Toothbrush_before.png](8kzkHfNYF3AI)

Then, the toothbrushes are positioned into the molds: 
![Injecting_before.png](3NZlAU0hi5eg)

The injection process consists of injecting the rubber and mainly controlling injection pressure, temperature, and curing time. 
<br>

![overmolding-and-insert-molding-process-illustration-900x600.png](sU74lb4GyB2C)
After injection, the toothbrushes have the rubber touch surfaces and are automatically unloaded to the next step.

![Injecting_after.png](175y0CXqYTsg)

![Toothbrush_after.png](VuWFhrz0cbhV)



## Dataset Description:

The first dataset is [Process data](dataset:process-data), which has been simplified and is focused on steam injection time

| Column          | description                                                                            | Modalities                           |
|-----------------|----------------------------------------------------------------------------------------|-------------------------------------|
| Press           | Injection machine name                                                                 | 20 machines from W01 to W20         |
| Recipe          | The recipe changes according to the kind of product, quantity of material injected,... | 10 Recipes                          |
| Date            | Date of the injection                                                                  | From June 1st, 2021 |
| InjectionTime |  Injection time               | 35s to 3335s                        |
| Temperature | Average temperature over injection                | 160 to 218 °C                      |
| Pressure | Average pressure over injection      | 35s to 3335s                        |
| CampaignID | Unique campaigns identifier | | 
| InjectionID | Unique injection identifier | |
| <span style="color:white">-</span> | <span style="color:white">-</span> | <span style="color:white">-</span> |


The second dataset is [Quality Data](dataset:quality-data) that indicates if a injectionID  has defects (linked to the overmolding process) or not:

| Column          | description                                                                            | Modalities                           |
|-----------------|----------------------------------------------------------------------------------------|-------------------------------------|
| InjectionID | Unique injection identifier | |
| defect | 1 if the injectionID has a defect |1 or 0 |