# Requirements
This section informs you about all the requirements needed to use this solution.
<br>
# Instance Requirements
This solution is only compatible with instances with  **Dataiku V12+**. 

Please also note that Dataiku instances with a builtin environment of Python2, instead of Python 3, will receive errors when opening the "Explanations" tab of the [Defects prediction](dashboard:hbZqqVP) Dashboard. See [Defects prediction](article:15) for the fix. 

## Code Environment
The project doesn't need a code environment.

## Filesystem

The version you have downloaded uses the filesystem managed only but a version of this project integrates streaming. 
<br>
# Data model

This solution requires two input datasets : 

1. The **process-data** dataset contains measurements from the machines stored in long format.

it's composed of the following columns :
- `timestamp`  (_Date_ ) : timestamp of the manufacturing
- `product_ID`  ( _string_ ) : unique identifier of a product
- `machine_name`( _string_ ) : name of the machine
- `Recipe`( _string_ ) : type of manufactured part
- `Campaign_ID` (_string_ ) : unique identifier of the campaigns
- `process_parameter_1` (_decimal_ ) : process parameter
- ...
- `process_parameter_n` (_decimal_ ) : process parameter


As illustrated, in this dataset,  **you can add as many column as you have process parameters** . These parameters will be used to create the machine learning model and will be sorted by most influencing.
<br>

2. The **quality-data** dataset contains a simplified view of quality results, it's composed of 2 columns:
- `product_ID`  ( _string_ ) : unique identifier of a product
- `defect`( _boolean_ ) :  indicates if the parts has defects or not
<br>


You can find information of the pre-loaded data in the [Project Context](article:1) and [Data Ingestion](article:10) articles.

To setup the project with your own data, you can use the [Dataiku Application](article:18)