var bs_init_script = document.createElement("script");
bs_init_script.type = "text/javascript";
bs_init_script.src = getWebAppBackendUrl('/fetch/commons/js/business_solutions/1.0/fetch_resources.js');
$("head").append(bs_init_script);
  
dku_bs_resources.addLinks(['/fetch/project/css/pqc/1.0/pqc.css']);
/** load business solution resources */
dku_bs_resources.load_resources(createOrUpdateGraphs).then(console.log(' Business solutions resources loaded '));



var dku_green_1 = '#36C9BF';
var dku_green_2 = '#27A39C';
var dku_green_3 = '#1D7671';


const charts_map = new Map();

const colors_map = new Map([
   ['Good Injections', dku_green_1],
   ['Defects', dku_green_3],
   ['24 average injection time', dku_green_2],
   ['24 average temperature', dku_green_1],
   ['24 average pressure', dku_green_3],
   ['InjectionTime', dku_green_3],
   ['Temperature', dku_green_2],
   ['Pressure', dku_green_1],
   ['Defect rate per machine', dku_green_1],
   ['24h total production', dku_green_2],
   ['defect rate', dku_green_2]
]);


function createOrUpdateGraphs() {

       $.getJSON(getWebAppBackendUrl('/getMetrics'), function (data) {
          graphs = data.graphs;
          $.each(data.graphs, function (index, graph) {
             if (charts_map.has(graph.dom_id)) {
                console.log('Updating graph : ' + graph.dom_id)
                updateGraph(charts_map.get(graph.dom_id), graph)
             } else {
                console.log('Creating graph : ' + graph.dom_id)
                var chart = createGraph(graph);
                if (chart !== undefined)
                   charts_map.set(graph.dom_id, chart)
                else
                   console.log('Graph creator is undefined for ' + graph.dom_id)
             }
          });
       });
    
}


function createGraph(graph) {
   var chartDom = document.getElementById(graph.dom_id);
  
  
   switch (graph.type) {
      case "gauge":
         return createGauge(graph);
      case "bar":
         return createBarChart(graph);
      case "scatter":
         return createScatterChart(graph);
      case "line":
         return createLineChart(graph);
      case "stacked":
         return createStackedChart(graph);
      case "radial_polar":
         return createRadialPolarChart(graph);
      default:
         break;
   }
   return undefined;

}

function updateGraph(chart, graph) {
   switch (graph.type) {
      case "gauge":
         updateGauge(chart, graph);
         break;
      case "bar":
         updateBarChart(chart, graph);
         break;
      case "scatter":
         updateScatterChart(chart, graph);
         break;
      case "line":
         updateLineChart(chart, graph);
         break;
      case "stacked":
         updateStackedChart(chart, graph);
         break;
      case "radial_polar":
         updateRadialPolarChart(chart, graph);
      default:
         break;
   }
}


function updateGauge(chart, graph) {
   chart.setOption({
      series: [{
         data: [{
            value: graph.value,
            name: graph.valueName,
            itemStyle: {
               color: colors_map.get(graph.name)
            }
         }]
      }]
   });
}

function createGauge(graph) {

   var chartDom = document.getElementById(graph.dom_id);
   
   var myChart = echarts.init(chartDom);
   var option;
   option = {
      title: {
         text: graph.name,
         left: "center"
     },
     legend: {
         show: false,
         type: 'scroll',
         top: 'bottom'
     },
     label: {
         show: false
     },
     tooltip: {
         trigger: 'item'
     },
      series: [{
         type: 'gauge',
         detail: {
            formatter: '{value} ' + graph.unit
         },
         data: [{
            value: graph.value,
            name: graph.valueName,
            itemStyle: {
               color: colors_map.get(graph.name)
            }
         }],
         min: graph.y_min,
         max: graph.y_max,
         startAngle: 225,
         endAngle: -45,
         radius: '75%'
      }]
   };
   option && myChart.setOption(option);
   return myChart;
}


function createBarChart(graph) {

   var chartDom = document.getElementById(graph.dom_id);
   var myChart = echarts.init(chartDom);
   var option;
   var values = [];
   var colored_x_values = [];
   graph.y_values.forEach((element, index) => {
      values.push({
         value: element,
         

      });
      colored_x_values.push({
         value: graph.x_values[index],
         itemStyle: {
            color: colors_map.get(element)
         }

      });
   });
   
   option = {
      title: {
         text: graph.name,
         left: "center"
     },
     grid: {
      left: '90px',
      right: '40px',
      bottom: '2%',
      containLabel: false
    },
     label: {
         show: false
     },
     tooltip: {
         trigger: 'item'
     },
      xAxis: {},
      yAxis: {
         type: 'category',
         data: values,
         inverse: true,

      },
      series: [{
         name: graph.name,
         type: 'bar',
         data: colored_x_values,
         label: {
            show: true,
            position: 'right'
         }
      }],
      legend: {
         show: false
      },
   };
   option && myChart.setOption(option);
   return myChart;
}

function updateBarChart(chart, graph) {

   var colored_x_values = [];
   graph.x_values.forEach((element, index) => {
      colored_x_values.push({
         value: element,
         itemStyle: {
            color: colors_map.get(graph.y_values[index])
         }

      });
   });

   chart.setOption({
      series: [{
         name: graph.name,
         type: 'bar',
         data: colored_x_values,
         label: {
            show: true,
            position: 'right',
         }
      }]
   });
}

function createLineChart(graph) {
   var chartDom = document.getElementById(graph.dom_id);
   var myChart = echarts.init(chartDom);
   var option;
   option = {
      
      tooltip: {
         trigger: 'axis'
      },
      grid: {
         left: '20px',
         right: '60px',
         bottom: '31px',
         containLabel: false
       },
      legend: {},
      toolbox: {
         show: false,
         feature: {
            dataZoom: {
               yAxisIndex: 'none'
            },
            dataView: {
               readOnly: false
            },
            magicType: {
               type: ['line', 'bar']
            },
            restore: {},
            saveAsImage: {}
         }
      },
      xAxis: {
         type: 'category',
         data: graph.x_values,
         show: false
      },
      yAxis: {
         type: 'value',
         show: false,  
         axisLabel: {
            formatter: '{value}'
         },
         min: 'dataMin',
         max: 'dataMax'
      },
      series: [{
         name: graph.name,

         type: 'line',
         data: graph.y_values,
         itemStyle: {
            color: colors_map.get(graph.name)
         },
         markPoint: {
            symbol: 'pin',
            symbolSize: 20,
            symbolRotate: 180,
            label: {
               fontSize: 10,
               position: "bottom"
            },
            data: [{
                  type: 'max',
                  name: 'Max'
               },
               {
                  type: 'min',
                  name: 'Min'
               }
            ]
         },
         markLine: {
            data: [{
               type: 'average',
               name: 'Avg'
            }]
         }
      }]
   };

   option && myChart.setOption(option);
   return myChart;
}

function updateLineChart(chart, graph) {


   chart.setOption({
      series: [{
         name: graph.name,
         type: 'line',
         data: graph.y_values,
         markPoint: {
            data: [{
                  type: 'max',
                  name: 'Max'
               },
               {
                  type: 'min',
                  name: 'Min'
               }
            ]
         },
         markLine: {
            data: [{
               type: 'average',
               name: 'Avg'
            }]
         }
      }]
   });
}

function createStackedChart(graph) {
   var chartDom = document.getElementById(graph.dom_id);
   var myChart = echarts.init(chartDom, null, {
      renderer: 'canvas',
      useDirtyRect: false
   });

   var legends = [];
   var series = [];
   var emphasisStyle = {
      itemStyle: {
         shadowBlur: 10,
         shadowColor: 'rgba(0,0,0,0.3)'
      }
   };

   graph.y_values_set.forEach((element, index) => {
      legends.push(element.name);
      series.push({
         name: element.name,
         type: 'bar',
         stack: 'one',
         emphasis: emphasisStyle,
         itemStyle: {
            color: colors_map.get(element.name)
         },
         data: element.values
      })
   });

   var option;

   option = {
      title: {
         text: graph.name,
         left: "center"
     },
     legend: {
         show: false,
         type: 'scroll',
         top: 'bottom'
     },
     label: {
         show: false
     },
     tooltip: {
         trigger: 'item'
     },
      legend: {
         data: legends,
         left: '10%'
      },
      brush: {

         toolbox: ['rect', 'polygon', 'lineX', 'lineY', 'keep', 'clear'],
         xAxisIndex: 0
      },
      toolbox: {
         show: false,
         feature: {
            magicType: {
               type: ['stack']
            },
            dataView: {}
         }
      },
      tooltip: {},
      xAxis: {
         data: graph.x_values.values,
         name: graph.x_values.name,
         axisLine: {
            onZero: true
         },
         splitLine: {
            show: false
         },
         splitArea: {
            show: false
         }
      },
      yAxis: {},
      grid: {
         bottom: 100
      },
      series: series
   };

   option && myChart.setOption(option);
   return myChart;

}

function updateStackedChart(chart, graph) {

   var legends = [];
   var series = [];
   var emphasisStyle = {
      itemStyle: {
         shadowBlur: 10,
         shadowColor: 'rgba(0,0,0,0.3)'
      }
   };

   graph.y_values_set.forEach((element, index) => {
      legends.push(element.name);
      series.push({
         name: element.name,
         type: 'bar',
         stack: 'one',
         emphasis: emphasisStyle,
         itemStyle: {
            color: colors_map.get(element.name)
         },
         data: element.values
      })

   });

   chart.setOption({
      legend: {
         data: legends,
         left: '10%'
      },
      series: series
   });

}


function createRadialPolarChart(graph) {
   var chartDom = document.getElementById(graph.dom_id);
   var myChart = echarts.init(chartDom, null, {
      renderer: 'canvas',
      useDirtyRect: false
   });

   var option;

   option = {
      title: {
         text: graph.name,
         left: "center"
     },
     legend: {
         show: false,
         type: 'scroll',
         top: 'bottom'
     },
     label: {
         show: false
     },
    grid: {
         left: '20px',
         right: '60px',
         bottom: '31px',
        top: '2px',
         containLabel: false
       },
     tooltip: {
         trigger: 'item'
     },
      polar: {
         radius: [30, '80%']
      },
      radiusAxis: {
         max: 'dataMax',
         show: false
      },
      angleAxis: {
         type: 'category',
         data: graph.polar_values,
         startAngle: 75
      },
      tooltip: {},
      series: {
         type: 'bar',
         data: graph.radius_values,
         coordinateSystem: 'polar',
         label: {
            show: false,
            position: 'insideTop',
            formatter: '{c}'
         },
         itemStyle: {
            color: colors_map.get(graph.name)
         }
      },
      backgroundColor: '#fff',
      animation: true
   };

   option && myChart.setOption(option);

   return myChart;

}

function updateRadialPolarChart(chart, graph) {

   chart.setOption({
      angleAxis: {
         type: 'category',
         data: graph.polar_values,
         startAngle: 75
      },
      tooltip: {},
      series: {
         type: 'bar',
         data: graph.radius_values,
         coordinateSystem: 'polar',
         label: {
            show: false,
            position: 'insideTop',
            formatter: '{c}'
         },
         itemStyle: {
            color: colors_map.get(graph.name)
         }
      },
   });

}


function createScatterChart(graph) {
   var chartDom = document.getElementById(graph.dom_id);
   var myChart = echarts.init(chartDom);
   var option;

   option = {
       title: {
         text: graph.name,
         left: "center"
     },
     legend: {
         show: false,
         type: 'scroll',
         top: 'bottom'
     },
     label: {
         show: false
     },
     tooltip: {
         trigger: 'item'
     },
      xAxis: {
         show: false
      },
      yAxis: {
         show: false
      },
      series: [{
         name: graph.name,
         symbolSize: 5,
         data: graph.values,
         type: 'scatter'
      }]
   };
   option && myChart.setOption(option);
   return myChart;

}

function updateScatterChart(chart, graph) {

   chart.setOption({
      series: [{
         name: graph.name,
         symbolSize: 5,
         data: graph.values,
         type: 'scatter'
      }]
   });
}