import datetime
import json
import os
from flask import Blueprint, make_response
from flask import Response

from pathlib import Path
import dataiku

from commons.python.fetch.static_resources import fetch_route
app.register_blueprint(fetch_route)


get_metrics_bp = Blueprint("get_metrics_bp", __name__)

def get_blue_prints():
    return [get_metrics_bp]




class Graph:
    def __init__(self, graph_name, graph_type, dom_id):
        self.name = graph_name
        self.type = graph_type
        self.dom_id = dom_id


class GaugeGraph(Graph):
    def __init__(self, graph_name, dom_id, value, y_min, y_max, serie_name, unit, value_name):
        Graph.__init__(self, graph_name, "gauge", dom_id)
        self.y_min = y_min
        self.y_max = y_max
        self.value = value
        self.serie_name = serie_name
        self.unit = unit
        self.valueName = value_name


class BarGraph(Graph):
    def __init__(self, graph_name, dom_id, x_values, y_values):
        Graph.__init__(self, graph_name, "bar", dom_id)
        self.x_values = x_values
        self.y_values = y_values


class ScatterGraph(Graph):
    def __init__(self, graph_name, dom_id, values, average):
        Graph.__init__(self, graph_name, "scatter", dom_id)
        self.values = values
        self.average = average


class LineGraph(Graph):
    def __init__(self, graph_name, dom_id, x_values, y_values, average):
        Graph.__init__(self, graph_name, "line", dom_id)
        self.x_values = x_values
        self.y_values = y_values
        self.average = average


class StackBar:
    def __init__(self, name, values):
        self.name = name
        self.values = values


class StackedGraph(Graph):
    def __init__(self, graph_name, dom_id, x_values, y_values_set):
        Graph.__init__(self, graph_name, "stacked", dom_id)
        self.x_values = x_values
        self.y_values_set = y_values_set


class RadialPolarGraph(Graph):
    def __init__(self, graph_name, dom_id, radius_values, polar_values):
        Graph.__init__(self, graph_name, "radial_polar", dom_id)
        self.radius_values = radius_values
        self.polar_values = polar_values


class PQCMetrics:
    def __init__(self, status, graphs):
        self.status = status
        self.graphs = graphs




# Extract metrics from datasets
# Daily production rate:
daily_production_rate = dataiku.Dataset('process-data-joined-new_prepared_by_DateTimeDay')
daily_production_rate_df = daily_production_rate.get_dataframe()
last_day = daily_production_rate_df.days_since_now_first.min()
daily_production_rate_df_7days = daily_production_rate_df[daily_production_rate_df.days_since_now_first <= (last_day + 7)]
daily_production_rate_df_7days['GoodInjections'] = daily_production_rate_df_7days["InjectionTime_count"] - \
                                                   daily_production_rate_df_7days["defect_sum"]

daily_prod_x = daily_production_rate_df_7days.DateTimeDay.tolist()
daily_prod_y_good_injections = daily_production_rate_df_7days.GoodInjections.tolist()
daily_prod_y_defect_sum = daily_production_rate_df_7days.defect_sum.tolist()

# 24h total productio Gauge
LastProduction = dataiku.Dataset('process-data-joined-new_prepared_filtered_by_days_since_now_prepared')
LastProduction_df = LastProduction.get_dataframe()
total_production = round(float(LastProduction_df[LastProduction_df['Press'] != ""]["count"].sum()), 2)

# Defect Rate Gauge
defect_rate = round(float(LastProduction_df[LastProduction_df['Press'] != ""]["defect_rate"].mean()), 2)





influencing_factors = dataiku.Dataset('last_24h_explanations_by_days_since_now')
influencing_factors_df = influencing_factors.get_dataframe()
influencing_factors_df = influencing_factors_df.T.nlargest(3, columns=0)
influencing_factors_df = influencing_factors_df.reset_index()
influencing_factors_df['index'] = influencing_factors_df['index'].str.split(r'_').str.get(1)
influencing_factors_df['index'] = influencing_factors_df['index'].str.split(r'_').str.get(0)
influencing_factors_df = influencing_factors_df.sort_values(by=[0],ascending=False)




#Most influencing factors:

factors_x = influencing_factors_df[0].round(3).tolist()
factors_y = influencing_factors_df['index'].tolist()
# Line data:
process_data_days_since_now = dataiku.Dataset('process-data-joined-new_prepared_24hfiltered_by_hours_since_now')
process_data_days_since_now_df = process_data_days_since_now.get_dataframe()
process_data_days_since_now_df = process_data_days_since_now_df.sort_values(by=['hours_since_now'])
process_data_days_since_now_df = process_data_days_since_now_df.dropna()
# Average Data:
process_data_days_since_now_avg = dataiku.Dataset('process-data-joined-new_prepared_24hfiltered_by_hours_since_now_by_days_since_now')
process_data_days_since_now_avg_df = process_data_days_since_now_avg.get_dataframe()

sparkline_x = process_data_days_since_now_df.hours_since_now.tolist()
injection_time_sparkline_y = round(process_data_days_since_now_df.InjectionTime_avg, 2).tolist()
pressure_sparkline_y = round(process_data_days_since_now_df.Pressure_avg, 2).tolist()

if (process_data_days_since_now_avg_df.empty):
    injection_time_sparkline_average = 0.0
    temperature_sparkline_average  = 0.0
    pressure_sparkline_average  = 0.0
else:
    injection_time_sparkline_average = round(process_data_days_since_now_avg_df.InjectionTime_avg_avg, 1)[1]
    temperature_sparkline_average = round(process_data_days_since_now_avg_df.Temperature_avg_avg, 1)[1]
    pressure_sparkline_average = round(process_data_days_since_now_avg_df.Pressure_avg_avg, 1)[1]


temperature_sparkline_y = round(process_data_days_since_now_df.Temperature_avg, 2).tolist()

# defect rate
defect_rate_per_machines = dataiku.Dataset('defect_rate_per_machines')
defect_rate_per_machines_df = defect_rate_per_machines.get_dataframe()
defect_rate_radius = defect_rate_per_machines_df.total_production.tolist()
defect_rate_theta = defect_rate_per_machines_df.Press.tolist()

metrics = PQCMetrics('ok', [GaugeGraph('総生産量（過去24時間）',
                                       '24h_total_production',
                                       total_production,
                                       0,
                                       2000, 'number of injections',
                                       '', 'Injections'),
                            GaugeGraph('欠陥率',
                                       'defect_rate',
                                       defect_rate,
                                       0,
                                       100,
                                       'Defect Rate', '%', 'Defect Percentage'),
                            BarGraph('最も影響力のある要因', 'most_influencing_factors',
                                     factors_x,
                                     factors_y),
                            LineGraph('平均射出時間', '24_avg_injection_time',
                                      sparkline_x, injection_time_sparkline_y, injection_time_sparkline_average),
                            LineGraph('平均気温', '24_avg_temperature',
                                      sparkline_x, temperature_sparkline_y, temperature_sparkline_average),
                            LineGraph('平均圧力', '24_avg_pressure',
                                      sparkline_x, pressure_sparkline_y, pressure_sparkline_average),
                            StackedGraph('日次生産量 (過去7日間)', 'daily_production_rate_last_7_days',
                                         StackBar('Date', daily_prod_x),
                                         [StackBar('Good Injections', daily_prod_y_good_injections),
                                          StackBar('Defects', daily_prod_y_defect_sum)]),
                            RadialPolarGraph('機器ごとの欠陥率', 'defect_rate_per_machine', defect_rate_radius,
                                             defect_rate_theta)

                            ])


@app.route('/getMetrics')
def get_metrics():
    return json.dumps(metrics.__dict__, default=lambda o: o.__dict__, indent=4)
    #return json.dumps(metrics.__dict__)

