## 概要

[欠陥予測ゾーン](flow_zone:dhNNDiZ)欠陥を予測するモデルの学習とスコアリングを行っています。
![flow_zone_defect_prediction.png](JrAHs41Ie1tD)

まず、リバランスした[履歴データセット](dataset:process-data-joined-historical-resampled)を使ってモデルを学習させます。

製造プロセスの目標は良い部品を作ることなので、品質予測では非常にアンバランスなデータセットが広く使われています。アンバランスなデータセットはよく知られた問題であり、それを解決するためにいくつかのオプションがあります。

ここでは、より正確な結果を得るために、データセットをダウンサンプリング（またはアンダーサンプリング）することを選択します。結果やプロセスの品質によっては、対応方法を変更することができます。リサンプリングステップは、モデリングを定義するのに非常に重要です。私たちのケースでは、50/50のおおよその比率でリバランスすることを選択しました。最大のリスクは、いくつかの動作を見逃し、欠陥が過剰に検出されることです。

もうひとつの理論的考察：F1スコアを最適化するために閾値を維持しましたが、これは心に留めておくべき重要なポイントです。例えば、品質管理のコストが部品の価格と比較して低い場合、産業界の状況に応じて、より多くの偽陽性（欠陥があると予測される良品部品）を持つことを望むかもしれません。これを最適化するための興味深いDataikuのツールが、[cost matrix](https://knowledge.dataiku.com/latest/courses/machine-learning/evaluate-model/evaluate-model.html#cost-matrix).です。

この例では、いくつかのモデルをトレーニングし、ランダムフォレストを導入しています。それでも、XGBoostの予想は非常によく、より多くの特徴量を追加することで改善でき、また処理スピードも速く終わります。その証拠に、この例では、XGBoostは10秒で学習され、Random Forestは50秒近くかかっています。
