import dash_bootstrap_components as dbc
from dash import html, dcc

def export_modal(project_key):
    return dbc.Modal([
            dbc.ModalHeader(dbc.ModalTitle("Export Dataset", style={'font-size': '14px'})),
            dbc.ModalBody(
                dbc.Col([
                    dbc.RadioItems(
                        options=[
                            {"label": "Full Traces Containing Selected Activity", "value": "full"},
                            {"label": "Only Selected Activity Rows", "value": "only"},
                        ],
                        value="full",
                        id="export-traces-input",
                    ),
                    dbc.Row([
                        dbc.Col(html.P("Dataset Name", style={'font-size': '12px'}), md=4),
                        dbc.Col(dbc.Input(id="export-name", placeholder="Dataset name", type="text", size='sm'), md=8)])
                    
                ])),
            dbc.ModalFooter(dbc.Row([
                dbc.Col(dbc.Button(
                    "Cancel",
                    id="cancel-export",
                    color="light",
                    className="sm",
                    n_clicks=0,
                ), md=6),
                dbc.Col([
                    dcc.Loading(id="link-loading"),
                        dbc.Button(
                            "Export",
                            id="modal-export-traces",
                            className="sm",
                        n_clicks=0
                )], md=6)])
            ),
        ],
        style={'z-index': 1000},
        id="export-modal",
        is_open=False)

def export_modal_edge(project_key):
    return dbc.Modal([
            dbc.ModalHeader(dbc.ModalTitle("Export Dataset", style={'font-size': '14px'})),
            dbc.ModalBody(
                dbc.Col([
                    dbc.RadioItems(
                        options=[
                            {"label": "Full Traces Containing Selected Transition", "value": "full"},
                            {"label": "Only Selected Transition" + " Rows", "value": "only"},
                        ],
                        value="full",
                        id="export-traces-input-edge",
                    ),
                    dbc.Row([
                        dbc.Col(html.P("Dataset Name", style={'font-size': '12px'}), md=4),
                        dbc.Col(dbc.Input(id="export-name-edge", placeholder="Dataset name", type="text", size='sm'), md=8)])
                    
                ])),
            dbc.ModalFooter(dbc.Row([
                dbc.Col(dbc.Button(
                    "Cancel",
                    id="cancel-export-edge",
                    color="light",
                    className="sm",
                    n_clicks=0,
                ), md=6),
                dbc.Col([dcc.Loading(id="link-loading-edge"),
                    dbc.Button(
                    "Export",
                    id="modal-export-traces-edge",
                    className="sm",
                    n_clicks=0
                )], md=6)])
            ),
        ],
        style={'z-index': 1000},
        id="export-modal-edge",
        is_open=False)
