import dash_bootstrap_components as dbc
from dash import html

def legend_object(min_value, max_value, transition='frequency'):
    return html.Div([
                # Text
#                 html.P(
#                     'Frequency' if transition=='frequency' else 'Time',
#                     style={'margin-right': '10px'}
#                 ),

                # Min value
                html.P(str(min_value), style={'margin-right': '5px'}),

                # Gradient legend
                html.Div(
                    id='gradient-legend',
                    style={
                            'display': 'inline-block',
                            'height': '20px',
                            'width': '100px',
                            'background': 'linear-gradient(to right, #F1F8FD, #7DBEEA)',
                            'margin-right': '5px',
                            'vertical-align': 'middle',
                            'margin-bottom': '16px'
                        }
                ),

                # Max value
                html.P(str(max_value))
            ], style={
                'display': 'flex',
                'align-items': 'center',
                'padding': '0',
                'margin-left': '6px'
            })