from webapp.formatting import formatted_human_readable
from dash import html
import dash_bootstrap_components as dbc
from webapp.selectors import filter_title
from webapp.styles import *

text_style = {'margin': '1px'}

def selected_node_card(node, selected_node, data, activities_count_df, transitions_df, total_cases):
    return [dbc.CardHeader(
                dbc.Row([
                    dbc.Col(filter_title(node), style={'font-weight': '700'}, md=10),
                    dbc.Col(html.Button(
                        html.I(className="fas fa-times", style={'text-align': 'right'}),
                        className="ml-auto close",
                        id='card-close-button',
                        style={'border-width': '0px',
                              'background-color': 'white'}
                    ), md=2)
                ], style={'margin-right': '2px'}), style={'background-color': 'white', 'border-bottom': '0px'}),
                dbc.CardBody(selected_node_window(selected_node, data, activities_count_df, transitions_df, total_cases),
                            style={'padding-top': 0})]

def selected_edge_card(source, target, nodes, data, transitions_df, total_cases):
     return [dbc.CardHeader(
                dbc.Row([
                    dbc.Col(filter_title(source + ' -> ' + target), 
                            style={'font-weight': '700'},
                            md=10),
                    dbc.Col(html.Button(
                            html.I(className="fas fa-times", style={'text-align': 'right'}),
                            className="ml-auto close",
                            id='card-close-button',
                        style={'border-width': '0px',
                              'background-color': 'white'}
                    ), md=2)
                ], style={'margin-right': '2px'}), style={'background-color': 'white', 'border-bottom': '0px'}),
                dbc.CardBody(selected_edge_window(nodes, data, transitions_df, total_cases),
                            style={'padding-top': 0})]

def selected_node_individual_card(node, selected_node, data, activities_count_df, transitions_df, total_cases):
    return [dbc.CardHeader(
                dbc.Row([
                    dbc.Col(filter_title(node), style={'font-weight': '700'}, md=10),
                    dbc.Col(html.Button(
                        html.I(className="fas fa-times", style={'text-align': 'right'}),
                        className="ml-auto close",
                        id='card-close-individual-button',
                        style={'border-width': '0px',
                              'background-color': 'white'}
                    ), md=2)
                ], style={'margin-right': '2px'}), style={'background-color': 'white', 'border-bottom': '0px'}),
                dbc.CardBody(selected_node_window(selected_node, data, activities_count_df, transitions_df, total_cases),
                            style={'padding-top': 0})]

def selected_edge_individual_card(source, target, nodes, data, transitions_df, total_cases):
     return [dbc.CardHeader(
                dbc.Row([
                    dbc.Col(filter_title(source + ' -> ' + target), 
                            style={'font-weight': '700'},
                            md=10),
                    dbc.Col(html.Button(
                            html.I(className="fas fa-times", style={'text-align': 'right'}),
                            className="ml-auto close",
                            id='card-close-individual-button',
                        style={'border-width': '0px',
                              'background-color': 'white'}
                    ), md=2)
                ], style={'margin-right': '2px'}), style={'background-color': 'white', 'border-bottom': '0px'}),
                dbc.CardBody(selected_edge_window(nodes, data, transitions_df, total_cases),
                            style={'padding-top': 0})]

    
def empty_card():
    return [dbc.CardHeader(
        [
            "",
            html.Button(
                html.I(className="fas fa-times"),
                className="ml-auto close",
                id='card-close-button',
            style={'float': 'right'}),
        ]),
        dbc.CardBody('')]

def empty_card_individual():
    return [dbc.CardHeader(
        [
            "",
            html.Button(
                html.I(className="fas fa-times"),
                className="ml-auto close",
                id='card-close-individual-button',
            style={'float': 'right'}),
        ]),
        dbc.CardBody('')]

def selected_node_window(node, data, activity_count_df, transitions_df, total_cases):
    activity = data[int(node)]
    row = activity_count_df[activity_count_df['activity']==activity]
    share_info = html.P('Activity present in ' + str(round(row['count'].iloc[0]/total_cases*100, 2)) + '% of the cases (' + str(row['count'].iloc[0]) + ')',
                       style=text_style)
    rows_from = transitions_df[transitions_df['activity']==activity]
    source_count = rows_from['count'].sum()
    successor = rows_from['activity_after'].iloc[rows_from['count'].argmax()]
    successor_count = rows_from[rows_from['activity_after']==successor]['count'].iloc[0]
    successor_info = html.P('Most likely successor: ' + successor + ' (' + str(round(successor_count/source_count*100, 2)) + '%, ' + str(successor_count) + ')', style=text_style)
    rows_to = transitions_df[transitions_df['activity_after']==activity]
    target_count = rows_to['count'].sum()
    predecessor = rows_to['activity'].iloc[rows_to['count'].argmax()]
    predecessor_count = rows_to[rows_to['activity']==predecessor]['count'].iloc[0]
    predecessor_info = html.P('Most likely predecessor: ' + predecessor + ' (' + str(round(predecessor_count/target_count*100, 2)) + '%, ' + str(predecessor_count) + ')', style=text_style)
    button = dbc.Button("Export Dataset", 
                             id='browse-node-traces', 
                             color="primary", 
                             n_clicks=0,
                             size='sm',
                             style=button_style)
    return dbc.Container(dbc.Col([share_info,
                             successor_info,
                             predecessor_info,
                             button
                            ]), style={'padding': 0})

def selected_edge_window(nodes, data, transitions_df, total_cases):
    source = data[int(nodes[0])]
    target = data[int(nodes[1])]
    row = transitions_df[(transitions_df['activity']==source) & (transitions_df['activity_after']==target)]
    share_info = html.P('Transition present in ' + str(round(row['count'].iloc[0]/total_cases*100, 2)) + '% of the cases (' + str(row['count'].iloc[0]) + ')', style=text_style)
    time_info = html.P('Transition time: Average ' + formatted_human_readable(row['avg_transition_time'].iloc[0]) + 
                           ' / Min ' + formatted_human_readable(row['min_transition_time'].iloc[0]) + 
                           ' / Max ' + formatted_human_readable(row['max_transition_time'].iloc[0]), style=text_style)
    button = dbc.Button("Export Dataset", 
                         id='browse-edge-traces', 
                         color="primary", 
                         n_clicks=0,
                         size='sm',
                         style=button_style)
    return dbc.Container(dbc.Col([share_info, time_info, button]), style={'padding': 0})