from dash import dcc, html
import dash_bootstrap_components as dbc

def variants_filter_object(default=5, max=100, tab='discovery'):
    if tab == 'discovery':
        display = 'block'
    else:
        display = 'None'
    variants_input = dcc.Input(
            id="variants-filter",
            type="number",
            value=default,
            min=1,
            max=max, 
            size=2,
            style={'float': 'left','margin-left': '4px', 'margin-right': '4px', 'width': '36px'})
    
    variants_filter = dbc.Col([
#         html.P('Variants', style={'font-weight': 'bold', 'margin-bottom': 0}),
        html.Div([html.P('Display the top ', style={'float': 'left','margin': 'auto', 'margin-top': '4px'}), 
                                variants_input, 
                                html.P(' out of ' + str(max) + ' variants (unique trace)', 
                                       style={'float': 'left', 'margin': 'auto', 'margin-top': '4px'})], style={'display': 'inline-block'}
                                )],style={'display': display, 'padding-left': '6px'})
    return variants_filter

def variants_container():
    return html.Div(children=variants_filter_object(),
                  id='variants-container')
