_This article is targeted at end-users of the Process Mining application._

The [Process Mining](dashboard:lngA9Pv) dashboard's **Case Explorer** helps identify outlier cases based on execution time or conformance score, and focus the Process Graph on individual cases. It complements the Process Explorer, which focuses on the overall process.

The interface includes:

- **Filters** (same as in the Process Explorer).
- **Data Table** displaying case details.
- **Process Graph** (same as in the Process Explorer).

![Case Explorer.png](k2JvSEtWjldT)

## Visualizing Individual Process Executions

Each row in the Data Table represents a case. To visualize a specific case in the Process Graph, **right-click** on its **Case ID** and select **"Include only [Case ID]"**.

![filter-by-case-id.png](4f377uCrJb5d)

This action adds a filter labeled "ONLY case: [Case ID]", which can be removed by clicking the three vertical dots next to it and selecting "Remove filter."

### Example

In the example below, the selected case’s execution reveals two loops.

![individual-execution.png](OtnRDaPZLWoD)

## Identifying Outliers

The **Data Table** contains case attributes, including those available as Filters. When **end timestamps** were available in the original process data, execution time is split into:

- **Processing time**: Active time spent on the case.
- **Idle time**: Time spent waiting between activities.

Sorting the table by execution time, processing time, idle time, or conformance score helps identify outliers.

> Contact your admin if any filters are missing or if you need the table sorted by a different column.

## Conformance

Each process execution is assigned a **conformance score** between 0 and 1, measuring its adherence to a _reference process model_ (higher is better).

> Before relying on conformance scores, check with your admin if a validated reference process model is in place. By default, the Case Explorer uses the top 5 variants as the reference model. See the Process Explorer documentation for details on updating this definition.

### How Conformance is Measured

The reference process model consists of reference variants—execution paths considered "acceptable."

For each case, its conformance score is the maximum similarity between:

- The sequence of activities in the case execution.
- The sequence of activities in each reference variant.
