# Installing a new version of Process Mining

As any Dataiku Solution, Process Mining is a Dataiku project equipped with the Dataiku App mechanism to easily create instances (copies) of the project and to configure their input data via a GUI. Being a Dataiku project, it comes as a .zip file that you can import to your Dataiku instance. This project includes code recipes and a code webapp that depend on a code environment with specific dependencies. Therefore, installing a new version of Process Mining involves...

- Updating/creating a code environment with the requirements for this new version.
- Importing the new Process Mining project (`dss-tutorial-SOL_PROCESS_MINING.zip`).

You will find the link to download the latest .zip file and the corresponding code environment requirements on the [Dataiku Knowledge Base](https://knowledge.dataiku.com/latest/solutions/operations/solution-process-mining.html).

## Updating/creating a new code environment

* Create a new code environment if you intend to use the new Solution version in parallel to the one that was already installed on your Dataiku instance. Name it after the new Solution version. For instance: `solution_process-mining_v1_4`.
* Use the **[new requirements](article:10)**.

## Importing the new Process Mining project

### Housekeeping tips

- Include the version number in the project key. For instance: `SOL_PROCESS_MINING_V1_4`.
- Navigate to the project and rename it to include the version number, e.g., _"Process Mining Solution V1.4"_. This is the name that will appear in the list of Projects of your Dataiku instance.
- Navigate to the project's Application Designer, and rename the Application in the same way. This is the name that will appear in the list of Applications of your Dataiku instance.

### Pointing to the new code environment

By default, the project's code recipes and webapp use the `solution_process-mining` code environment. If you created a new code environment to allow usage of different versions of the Solution in parallel, update the new project to use the new code environment, via the **Code env selection** section of the **Project settings**.

### Customizations

- If you had performed any customizations in the previous template project, you will need to apply them again to the new one.

# Creating instances of the new version

- Include the version name in the new project key. For instance: `LOANS_PROCESS_MINING_V1_4` when mining a loan application process.
- Reuse the same settings as in the instance that was created with the previous Solution version, build, and test.
- If you had performed any customizations in the previous instance, try to move them to a separate project, so you don't need to manually reimplement these customizations whenever you want to use a new version of the Solution. This is relevant for…
  - Recipes that are upstream of the dataset used as input to the Solution's pre-made Flow: these should be moved to a process-specific data preparation project, which can be named after the process and suffixed by "Prep". For instance: "Loans Prep".
  - Recipes and Charts that are downstream of the Solution's intermediate and output datasets: these can be moved to a project named after the process and suffixed by "Monitoring". We recommend publishing dashboards from the Process Mining instance and from the Monitoring project to the same Dataiku Workspace dedicated to the process being mined.
- If tests are successful:
  - Replace dashboards from Workspaces that were created with the previous version of the Solution.
  - Mark the status of the new instance as In Use and the old instance as Deprecated or Archived.

# Using different versions in parallel with Project Statuses

We recommend using project Statuses for the template project (`SOL_PROCESS_MINING_VX_Y`) and for its instances:

- _Sandbox_: great for testing new versions of the Solution    
- _In Use_: great for process discovery efforts during which we can expect customizations
- _In Production_: great for stable usage in production, notably for continuous monitoring purposes
- _Deprecated_: great for versions that should not be used anymore, but that are still available for reference

This enables users to distinguish between different versions of the same solution on the same processes, without having to know version numbers.
