from flask import Blueprint, Response, request
import time
import time
import datetime
import json

from commons.python.dku_utils.folders.pictures.folder_pictures import (
    read_picture_bytes_from_managed_folder,
)
from project.src.webapp_loading_functions import (
    load_user_recommendation_data
)
from project.src.webapp_data import (project, use_product_pictures, app_manifest, item_pictures_mapping,
                                     user_interactions_data, user_recommendations_data,
                                     leverage_item_metadata, item_metadata_columns,
                                     item_metadata_mapping, user_recommendations_data, 
                                     deployed_model_threshold, probability_label_helpers,
                                     PICTURES_FOLDER_NAME, WEBAPP_FOLDER_NAME, PROBABILITY_LABELS,
                                     PROBABILITY_LABEL_COLORS)

fetch_api = Blueprint("fetch_api", __name__)
start_time = time.time()

print(
    "Backend data successfully loaded in {} seconds !".format(time.time() - start_time)
)


@fetch_api.route("/api/get_application_manifest")
def get_application_manifest():
    return json.dumps(app_manifest)


@fetch_api.route("/api/get_webapp_initial_result")
def get_webapp_initial_result():
    return None  # results_data


@fetch_api.route("/api/get_item_picture_bytes/<item_id>")
def get_item_picture_bytes(item_id):
    print("item_id = {}".format(item_id))
    if use_product_pictures:
        file_name = item_pictures_mapping[item_id]
        print("picture to get : {}".format(file_name))
    else:
        file_name = ""
    try:
        picture_bytes = read_picture_bytes_from_managed_folder(
            project, PICTURES_FOLDER_NAME, "/{}".format(file_name)
        )
    except:
        picture_bytes = read_picture_bytes_from_managed_folder(
            project, WEBAPP_FOLDER_NAME, "/webapp_default_picture.jpg"
        )
    status = 200
    cache_days = 30
    expiry_time = datetime.datetime.utcnow() + datetime.timedelta(cache_days)
    response = Response(response=picture_bytes, status=status, mimetype="image/jpg")

    if status == 200:
        response.headers["Cache-Control"] = "public"
        response.cache_control.max_age = cache_days * 86400
        response.headers["Expires"] = expiry_time.strftime("%a, %d %b %Y %H:%M:%S GMT")

    return response


@fetch_api.route("/api/process_webapp_settings", methods=["POST"])
def process_webapp_settings():
    params = request.get_json(force=True)
    print("params: '{}'".format(params))
    user_id = params.get("user_selection")
    user_selected_data = (user_id is not None)
    if user_selected_data:
        display_already_purchased_items = params["display_already_purchased_items"]
        results_display_style = params["results_display_style"]
        user_past_interaction_items = user_interactions_data[user_id][
            "historical_interactions"
        ]
        user_recommendation_items = user_recommendations_data[user_id][
            "recommendations"
        ]
        if display_already_purchased_items == False:
            user_recommendation_items = [
                item_id
                for item_id in user_recommendation_items
                if item_id not in user_past_interaction_items
            ]

        print("Loading items pictures associated with user selection ...")
        loading_start_time = time.time()
        user_item_past_interactions_data, user_recommendation_legend_section_ids, user_recommendation_legend_section_information = load_user_recommendation_data(
            results_display_style,
            user_id,
            user_past_interaction_items,
            leverage_item_metadata,
            item_metadata_columns,
            item_metadata_mapping,
            user_recommendations_data,
            deployed_model_threshold,
            "past_interaction_items",
            PROBABILITY_LABELS,
            PROBABILITY_LABEL_COLORS,
             probability_label_helpers
        )
        user_item_recommendations_data, user_recommendation_legend_section_ids, user_recommendation_legend_section_information = load_user_recommendation_data(
            results_display_style,
            user_id,
            user_recommendation_items,
            leverage_item_metadata,
            item_metadata_columns,
            item_metadata_mapping,
            user_recommendations_data,
            deployed_model_threshold,
            "recommendation_items",
            PROBABILITY_LABELS,
            PROBABILITY_LABEL_COLORS,
             probability_label_helpers
        )        

        legend_section_data = {"legend_section_ids": user_recommendation_legend_section_ids, "legend_sections_information": user_recommendation_legend_section_information}
        loading_time = time.time() - loading_start_time
        print("All pictures loaded in {} seconds !".format(loading_time))
        response = {
            "vertical_split_left": {
                "results_display_style": results_display_style,
                "items_data": user_item_past_interactions_data,

            },
            "vertical_split_right": {
                "results_display_style": results_display_style,
                "items_data": user_item_recommendations_data,
                "legend_section_data": legend_section_data
            },
        }
    else:
        response = {}
    return response