import { createStore } from "vuex";
import { API } from "../Api";

export default createStore({
  state: {
    user_selection: {},
    parameters_avalability: {},
    has_results_to_display: false,
    results_data: {},
    application_manifest: {},
    application_manifest_is_loaded: false,
  },
  getters: {
    gatherParameterData: (state) => (id) => {
      return state.user_selection.parameter_id;
    },
  },
  mutations: {
    GET_APPLICATION_MANIFEST(state, application_manifest) {
      state.application_manifest = application_manifest;
      state.application_manifest_is_loaded = true;
      console.log("Application manifest received !");
    },
    UPDATE_USER_SELECTION(state, parameter_data) {
      state.has_results_to_display = false;
      state.results_data = {};
      console.log("Updating user selection ...");
      state.user_selection[parameter_data.parameter_id] =
        parameter_data.parameter_selection;
      console.log("User selection updated !");
      console.log(
        `User selection is : ${JSON.stringify(state.user_selection)}`
      );
    },
    UPDATE_RESULTS_DATA(state, new_webapp_results) {
      console.log("Updating webapp results ...");
      state.results_data = new_webapp_results;
      if (Object.keys(new_webapp_results).length > 0) {
        state.has_results_to_display = true;
      } else {
        state.has_results_to_display = false;
      }
      console.log("Webapp results updated !");
    },
  },
  actions: {
    loadApplicationData({ commit }) {
      API.getApplicationManifest()
        .then((response) => {
          commit("GET_APPLICATION_MANIFEST", response);
        })
        .catch((error) => {
          console.log(error);
        });
    },
    refreshWebappResults({ commit }, parameter_data) {
      commit("UPDATE_USER_SELECTION", parameter_data);
      API.postWebappSettings(this.state.user_selection)
        .then((response) => {
          commit("UPDATE_RESULTS_DATA", response);
        })
        .catch((error) => {
          console.log(error);
        });
    },
  },
  modules: {},
});
