export function getSelectValues(selector_id) {
    let select = document.getElementById(selector_id);
    let result = [];
    let options = select && select.options;
    let option;
  
    for (let i = 0, n_options = options.length; i < n_options; i++) {
      option = options[i];
  
      if (option.selected) {
        result.push(option.value || option.text);
      }
    }
    return result;
  }
  
export function displayBase64ImageInDiv(div_id, base64Image, image_format, image_id) {
    // image placeholder where the image will be displayed
    let div_placeholder = document.getElementById(`${div_id}`);
    let image = document.createElement("img");
    image.src = `data:image/${image_format};base64,${base64Image}`;
    image.onload = function () {
      div_placeholder.innerHTML = "";
      this.id = image_id;
      div_placeholder.appendChild(this);
    };
  }
  