from project.src.webapp_manifest import APP_MANIFEST
from project.src.webapp_utils import set_app_manifest_select_values
from project.src.webapp_project_key import (
  PROJECT_KEY)
from commons.python.dku_utils.core import get_project_and_variables
from commons.python.dku_utils.folders.pickles.folder_pickles import (
    read_pickle_from_managed_folder,
)

project, variables = get_project_and_variables(PROJECT_KEY)
WEBAPP_FOLDER_NAME = "webapp_folder"
PICTURES_FOLDER_NAME = "item_pictures_resized"
PROBABILITY_LABELS = ["High", "Good", "Almost good", "Low", "Very Low"]
PROBABILITY_LABEL_COLORS = {"High": "#1B5E21",
                              "Good": "#388E3C",
                              "Almost good": "#1976D2",
                              "Low": "#F57C00",
                              "Very Low": "#E65100"}
app_variables = variables["standard"]

#interaction_rank_item_mapping = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "interaction_rank_item_mapping.p") 
#item_recommendations_data = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "item_recommendations_data.p")
#interaction_rank_user_mapping = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "interaction_rank_user_mapping.p")
#item_similarities_data = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "item_similarities_data.p")
items_with_recommendations = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "items_with_recommendations.p")
#items_with_similarities = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "items_with_similarities.p")
#recommendation_rank_item_mapping = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "recommendation_rank_item_mapping.p")
user_interactions_data = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "user_interactions_data.p")
user_recommendations_data = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "user_recommendations_data.p")
users_with_recommendations = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "users_with_recommendations.p")

# Batch information:
batch_information = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "batch_information.p")
deployed_model_threshold = batch_information["deployed_model_threshold"]

# Item pictures:
use_product_pictures = app_variables.get("use_product_pictures_app")
if use_product_pictures:
  item_pictures_mapping = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "item_pictures_mapping.p")
else:
  item_pictures_mapping = {}

# Item metadata:
leverage_item_metadata = app_variables["leverage_item_metadata_app"]
if leverage_item_metadata:
  item_metadata_columns = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "item_metadata_columns.p")
  item_metadata_mapping = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "item_metadata_mapping.p")
else:
  item_metadata_columns = []
  item_metadata_mapping = {}

# User metadata:
leverage_user_metadata = app_variables["leverage_user_metadata_app"]
if leverage_user_metadata:
  user_metadata_columns = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "user_metadata_columns.p")
  user_metadata_mapping = read_pickle_from_managed_folder(project, WEBAPP_FOLDER_NAME, "user_metadata_mapping.p")

else:
  user_metadata_columns = []
  user_metadata_mapping = {}

probability_label_helpers = {"High": "Probabilities above the current model threshold of '{}'.".format(deployed_model_threshold),
                              "Good": "Probabilities above the current model threshold of '{}' but still close to it.".format(deployed_model_threshold),
                              "Almost good": "Probabilities close to the current model threshold of '{}' but under it.".format(deployed_model_threshold),
                              "Low": "Probabilities reasonably under the current model threshold of '{}'.".format(deployed_model_threshold),
                              "Very Low": "Probabilities too far under the current model threshold of '{}'.".format(deployed_model_threshold)}

select_options = [user_id for user_id in users_with_recommendations]
select_options_filtered = select_options[0:100]

app_manifest = set_app_manifest_select_values(APP_MANIFEST, select_options_filtered)