def get_deployed_model_metadata(project, deployed_model_name):
    """
    Retrieves the information associated with a project deployed model. 

    :param project: dataikuapi.dss.project.DSSProject: A handle to interact with a project on the DSS instance.
    :param deployed_model: str: Name of the project deployed model.

    :returns: deployed_model_metadata: dict: The associated with 'flow_zone_name'.
    """
    all_deployed_models_information = project.list_saved_models()
    deployed_model_metadata = None
    for deployed_model_information in all_deployed_models_information:
        if deployed_model_information['name'] == deployed_model_name:
            deployed_model_metadata = deployed_model_information
            pass
        pass
    if deployed_model_metadata == None:
        log_message = "Deployed model '{}' does not exist! "\
            "Please use the computed 'all_deployed_models_information' to use a valid model name."\
            "all_deployed_models_information = '{}'".format(deployed_model_name, all_deployed_models_information)
        raise Exception(log_message)
    return deployed_model_metadata
    

def get_deployed_model_id(project, deployed_model_name):
    """
    Retrieves the ID of a project deployed model. 

    :param project: dataikuapi.dss.project.DSSProject: A handle to interact with a project on the DSS instance.
    :param deployed_model_name: str: Name of the project deployed model.

    :returns: deployed_model_id: str: The ID associated with 'deployed_model_name'.
    """
    deployed_model_metadata = get_deployed_model_metadata(project, deployed_model_name)
    deployed_model_id = deployed_model_metadata["id"]
    return deployed_model_id
