# Model/Ages clustering constants:
AGES_CLUSTERING_MODEL_ANALYSIS_ID = "rCQLKi7I"
AGES_CLUSTERING_MODEL_ML_TASK_ID = "f6dBZDIm"
AGES_CLUSTERING_TRAINING_RECIPE_NAME = "train_ages_clustering_model"
AGES_CLUSTERING_DEPLOYED_MODEL_ID = "uAq5AxzM"

# Model/Recommendation modeling constants:
RECOMMENDATION_MODELING_MODEL_ANALYSIS_ID = "srEIpcVP"
RECOMMENDATION_MODELING_MODEL_ML_TASK_ID = "PxASd9aA"
RECOMMENDATION_MODELING_TRAINING_RECIPE_NAME = "train_recommendation_model"
RECOMMENDATION_MODELING_DEPLOYED_MODEL_ID = "TT58nj9o"

# Auto ML:
FORBIDDEN_FEATURES = ["user_id", "item_id"]
RECOMMENDATION_MODELING_DATASET =  "final_machine_learning_set_prepared"
CLASSIFICATION_TARGET = "user_interaction"
TEST_SET_FRACTION_IN_SUBPOPULATION_ANALYSIS = 1.0
TEST_SET_FRACTION_IN_PARTIAL_DEPENDENCIES = 0.1

NUMERICAL_VALUES_PROCESSING = {
    'generate_derivative': False,
    'numerical_handling': 'REGULAR',
    'missing_handling': 'IMPUTE',
    'missing_impute_with': 'MEDIAN',
    'impute_constant_value': 0.0,
    'keep_regular': False,
    'rescaling': 'MINMAX',
    'quantile_bin_nb_bins': 4,
    'binarize_threshold_mode': 'MEDIAN',
    'binarize_constant_threshold': 0.0,
    'datetime_cyclical_periods': [],
    'role': 'INPUT',
    'type': 'NUMERIC',
    'customHandlingCode': '',
    'customProcessorWantsMatrix': False,
    'sendToInput': 'main'
}


CATEGORICAL_VALUES_PROCESSING = {
    'category_handling': 'DUMMIFY',
    'missing_handling': 'NONE',
    'missing_impute_with': 'MODE',
    'dummy_clip': 'MAX_NB_CATEGORIES',
    'cumulative_proportion': 0.95,
    'min_samples': 10,
    'max_nb_categories': 20,
    'max_cat_safety': 200,
    'nb_bins_hashing': 1048576,
    'hash_whole_categories': True,
    'dummy_drop': 'AUTO',
    'impact_method': 'M_ESTIMATOR',
    'impact_m': 10,
    'impact_kfold': True,
    'impact_kfold_k': 5,
    'impact_kfold_seed': 1337,
    'ordinal_order': 'COUNT',
    'ordinal_ascending': False,
    'ordinal_default_mode': 'HIGHEST',
    'ordinal_default_value': 0,
    'frequency_default_mode': 'EXPLICIT',
    'frequency_default_value': 0.0,
    'frequency_normalized': True,
    'role': 'INPUT',
    'type': 'CATEGORY',
    'customHandlingCode': '',
    'customProcessorWantsMatrix': False,
    'sendToInput': 'main'
}