from ....dku_utils.recipes.join_recipe import (programmaticJoinHandler, compute_join_recipe_computed_column_settings)
from ....dku_utils.datasets.dataset_commons import (get_dataset_schema, set_dataset_schema)
from ....dku_utils.recipes.recipe_commons import update_recipe_ouput_schema
from ....dku_utils.recipes.stack_recipe import (instantiate_stack_recipe, set_stack_recipe_origin_column)
from ....dku_utils.recipes.group_recipe import (instantiate_group_recipe, define_group_recipe_aggregation_key,
                                                define_group_recipe_aggregations, override_group_recipe_output_column_names)
from ....dku_utils.recipes.join_recipe import (instantiate_join_recipe, programmaticJoinHandler,
                                               compute_join_recipe_computed_column_settings)
from ....dku_utils.recipes.plugin_recipes.plugin_recipe_commons import PluginRecipeHandler
from ....dku_utils.flow.flow_commons import create_flow_zone_if_not_exists, move_dataset_in_flow_zone
from ....dku_utils.connections.sql.connection_change import (compute_sql_table_name,
                                                              change_sql_dataset_table)
from ..application.loading_functions import load_contextual_collaborative_filtering_feature_datasets


def create_contextual_collaborative_filtering_flow_branch(project,
                                                          contextual_collaborative_filtering_feature_name,
                                                          collaborative_filtering_parameters,
                                                          datasets_connection_name):
    connection_type = project.get_variables()["standard"]["connection_type_app"]
    # Building collaborative filtering plugin recipes:
    PLUGIN_RECIPE_TYPE = "CustomCode_recommendation-system-auto-collaborative-filtering"
    contextual_collaborative_filtering_datasets_to_build =\
        load_contextual_collaborative_filtering_feature_datasets(contextual_collaborative_filtering_feature_name)
    ## All interactions:
    ALL_INTERACTIONS_INPUT = "user_item_interactions"
    all_interactions_output = contextual_collaborative_filtering_datasets_to_build[0]
    all_interactions_recipe_name = "_compute_{}".format(all_interactions_output)
    all_interactions_input_references_mapping = {ALL_INTERACTIONS_INPUT: "samples_dataset"}
    all_interactions_output_references_mapping = {all_interactions_output: "scored_samples_dataset"}

    all_interactions_plugin_handler = PluginRecipeHandler(project, plugin_recipe_type=PLUGIN_RECIPE_TYPE,
                                                          recipe_name=all_interactions_recipe_name,
                                                          plugin_input_references_mapping=all_interactions_input_references_mapping,
                                                          plugin_output_references_mapping=all_interactions_output_references_mapping,
                                                          input_dataset_names=[ALL_INTERACTIONS_INPUT], output_dataset_names=[all_interactions_output],
                                                          datasets_connection_name=datasets_connection_name, input_folder_names=[],
                                                          output_folder_names=[], folders_connection_name=None)
    all_interactions_plugin_handler.instantiate_plugin_recipe()
    all_interactions_plugin_handler.set_recipe_parameters(collaborative_filtering_parameters)
    output_table_name = compute_sql_table_name(project, connection_type, all_interactions_output)
    change_sql_dataset_table(project, all_interactions_output, output_table_name)
    
    ## Engineering set:
    ENGINEERING_INPUT = "collaborative_filtering_set"
    engineering_output = contextual_collaborative_filtering_datasets_to_build[1]       
    engineering_recipe_name = "_compute_{}".format(engineering_output)
    engineering_input_references_mapping = {ENGINEERING_INPUT: "samples_dataset"}
    engineering_output_references_mapping = {engineering_output: "scored_samples_dataset"}
    engineering_plugin_handler = PluginRecipeHandler(project, plugin_recipe_type=PLUGIN_RECIPE_TYPE,
                                                     recipe_name=engineering_recipe_name,
                                                     plugin_input_references_mapping=engineering_input_references_mapping,
                                                     plugin_output_references_mapping=engineering_output_references_mapping,
                                                     input_dataset_names=[ENGINEERING_INPUT], output_dataset_names=[engineering_output],
                                                     datasets_connection_name=datasets_connection_name, input_folder_names=[],
                                                     output_folder_names=[], folders_connection_name=None)
    engineering_plugin_handler.instantiate_plugin_recipe()
    engineering_plugin_handler.set_recipe_parameters(collaborative_filtering_parameters)
    output_table_name = compute_sql_table_name(project, connection_type, engineering_output)
    change_sql_dataset_table(project, engineering_output, output_table_name)
    
    ## Setting collaborative filtering dataset schemas:
    all_interactions_input_schema = get_dataset_schema(project, ALL_INTERACTIONS_INPUT)
    collaborative_filtering_datasets_schema = []
    key_columns_schema_information = {}
    
    for schema_information in all_interactions_input_schema:
        column_name = schema_information["name"]
        if column_name in ["user_id", contextual_collaborative_filtering_feature_name]:
            key_columns_schema_information[column_name] = schema_information
            pass
        pass

    collaborative_filtering_datasets_schema.append(key_columns_schema_information[contextual_collaborative_filtering_feature_name])
    collaborative_filtering_datasets_schema.append(key_columns_schema_information["user_id"])
    collaborative_filtering_datasets_schema.append({'name': 'score', 'type': 'double'})
    
    for dataset_name in [all_interactions_output, engineering_output]:
        set_dataset_schema(project, dataset_name, collaborative_filtering_datasets_schema)
        pass
    
    # All interactions and feature engineering outputs stacking:
    stack_recipe_output = contextual_collaborative_filtering_datasets_to_build[2]
    stack_recipe_name = "_compute_{}".format(stack_recipe_output)
    stack_recipe_inputs = [all_interactions_output, engineering_output]
    instantiate_stack_recipe(project, stack_recipe_name, stack_recipe_inputs,
                         stack_recipe_output, datasets_connection_name)
    stack_recipe_origin_column_name = "affinity_set"
    stack_recipe_origin_column_labels = ["scoring", "learning"]
    set_stack_recipe_origin_column(project, stack_recipe_name, stack_recipe_origin_column_name, stack_recipe_origin_column_labels)
    update_recipe_ouput_schema(project, stack_recipe_name)
    output_table_name = compute_sql_table_name(project, connection_type, stack_recipe_output)
    change_sql_dataset_table(project, stack_recipe_output, output_table_name)
    
    # All contextual feature data aggregation:
    group_recipe_output = contextual_collaborative_filtering_datasets_to_build[3]
    group_recipe_name = "_compute_{}".format(group_recipe_output)
    group_recipe_input = stack_recipe_output
    instantiate_group_recipe(project, group_recipe_name, group_recipe_input,
                             group_recipe_output, datasets_connection_name)
    group_recipe_aggregation_key = ["affinity_set", contextual_collaborative_filtering_feature_name]
    define_group_recipe_aggregation_key(project, group_recipe_name, group_recipe_aggregation_key, True)
    group_recipe_aggregations = {'score': ['min', 'max']} 
    define_group_recipe_aggregations(project, group_recipe_name, group_recipe_aggregations, False)
    score_min_column = '{}_score_min'.format(contextual_collaborative_filtering_feature_name)
    score_max_column = '{}_score_max'.format(contextual_collaborative_filtering_feature_name)
    group_recipe_columne_name_overrides = {
        'score_min': score_min_column,
        'score_max': score_max_column
        }
    override_group_recipe_output_column_names(project, group_recipe_name, group_recipe_columne_name_overrides)
    update_recipe_ouput_schema(project, group_recipe_name)
    output_table_name = compute_sql_table_name(project, connection_type, group_recipe_output)
    change_sql_dataset_table(project, group_recipe_output, output_table_name)
    
    # Joining all contextual features data: 
    join_recipe_output = contextual_collaborative_filtering_datasets_to_build[4]
    join_recipe_name = "_compute_{}".format(join_recipe_output)
    join_recipe_inputs = [stack_recipe_output, group_recipe_output]
    instantiate_join_recipe(project, join_recipe_name, join_recipe_inputs,
                            join_recipe_output, datasets_connection_name)
    
    join_column_alias = {"score": "{}_score".format(contextual_collaborative_filtering_feature_name)}
    join_handler = programmaticJoinHandler(project=project, recipe_name=join_recipe_name,
                                           main_dataset_name=stack_recipe_output,
                                           main_dataset_columns_to_select=[contextual_collaborative_filtering_feature_name, 'user_id', 'score', 'affinity_set'],
                                           main_dataset_columns_to_select_alias=join_column_alias,
                                           main_dataset_computed_columns=[])
    left_join_key = [contextual_collaborative_filtering_feature_name, "affinity_set"]
    right_join_key = left_join_key.copy()
    join_handler.add_one_join_on_main_dataset(group_recipe_output, [score_min_column, score_max_column],
                                              {}, [], "LEFT", "", left_join_key, right_join_key)
    computed_column_name = "{}_score_scaled".format(contextual_collaborative_filtering_feature_name)
    computed_column_expression = "({0}_score - {0}_score_min)/({0}_score_max - {0}_score_min)".format(contextual_collaborative_filtering_feature_name)
    join_computed_column_settings = compute_join_recipe_computed_column_settings(computed_column_name, "double", computed_column_expression)
    join_handler.add_post_join_computed_column(join_computed_column_settings)
    update_recipe_ouput_schema(project, join_recipe_name)
    output_table_name = compute_sql_table_name(project, connection_type, join_recipe_output)
    change_sql_dataset_table(project, join_recipe_output, output_table_name)

    # Grouping created flow branch elements in a dedicated flow zone:
    flow_zone_name = "collaborative_filtering|{}".format(contextual_collaborative_filtering_feature_name)
    create_flow_zone_if_not_exists(project, flow_zone_name, "#e0c587")
    current_branch_datasets = [all_interactions_output, engineering_output,
                               stack_recipe_output, group_recipe_output, join_recipe_output]
    for dataset_name in current_branch_datasets:
        move_dataset_in_flow_zone(project, dataset_name, flow_zone_name)
    pass