FLOW_REFRESH_SCENARIO_ID = "REFRESH_FLOW_OVER_TIME"

FLOW_INPUT_DATASETS = ["interactions_history", "user_metadata", "item_metadata"]

FLOW_INPUT_DATASETS_TO_PRESERVE = []
FLOW_INPUT_FOLDERS = ["item_pictures"]

# 'FALLBACK_CONNECTION_DATASETS' are datasets that are python processes outputs and that needs to be written in a cloud provicer cloud storage. 
# Some of them will then need to be synchronized in the main SQL connection, leveraging 'FALLBACK_CONNECTION_DATASETS_DOWNSTREAM_RECIPES': 
FALLBACK_CONNECTION_DATASETS = ["items_kept", "items_rejected", "all_item_distributions_information", "hyperactive_users",
                                "user_hyperactivity_threshold", "date_weeks", "batch_users_with_ages_clusters",
                                "user_interaction_predictions", "users_recommendation_pipeline", "items_recommendation_pipeline"
                               ]

FALLBACK_CONNECTION_DATASETS_DOWNSTREAM_RECIPES = {
    "items_kept": ["compute_user_item_interactions"],
    "user_hyperactivity_threshold": ["compute_user_item_interactions"],
    "date_weeks": ["compute_date_scopes"],
    "batch_users_with_ages_clusters": ["compute_user_item_interactions", "compute_final_machine_learning_set_enriched"],
    "user_interaction_predictions": ["compute_user_top_interaction_predictions"]
}


WEEK_COMPONENTS_SCHEMA = [
    {'name': 'date', 'type': 'date'}, {'name': 'year', 'type': 'bigint'},
    {'name': 'week_of_year', 'type': 'bigint'}, {'name': 'past_week_rank', 'type': 'bigint'},
    {'name': 'week_scope', 'type': 'string'}
]

APP_DATE_COMPONENTS_TO_REMOVE = ["hour", "minute", "second", "microsecond"]


STARTER_SCENARIOS_TO_PREPROCESS_INPUTS = ["PREPROCESS_INTERACTIONS_HISTORY"]
STARTER_SCENARIOS_FOR_ITEMS_ANALYSIS_AND_SELECTION = ["COMPUTE_ITEM_INTERACTIONS_DATA"]
STARTER_SCENARIOS_TO_BUILD_ALL_FLOW = ["BUILD_INPUTS_PREPROCESSING",
                                       "BUILD_ITEMS_ANALYSIS_AND_SELECTION",
                                       "BUILD_USERS_ANALYSIS_AND_SELECTION",
                                       "BUILD_TIME_SPLIT_DESIGN"]

COLLABORATIVE_FILTERING_PARAMETERS = {
    'user_visit_threshold': 1,
    'item_visit_threshold': 10,
    'timestamp_filtering': False,
    'top_n_most_recent': 20,
    'collaborative_filtering_method': 'item_based',
    'top_n_most_similar': 10,
    'users_column_name': 'user_id',
    'items_column_name': 'TMP_COLUMN_NAME' # Parameter value to be adapted depending on the column of interest
}

NEGATIVE_SAMPLING_BASE_PARAMETERS = {
    'historical_samples': True,
    'sampling_method': 'negative_samples_percentage',
    'negative_samples_percentage': 99,
    'score_column_names': [
        'item_score',
        'item_score_max',
        'item_score_min',
        'item_score_scaled'
    ],
    'scored_samples_users_column_name': 'user_id',
    'scored_samples_items_column_name': 'item_id',
    'training_samples_users_column_name': 'user_id',
    'training_samples_items_column_name': 'item_id',
    'historical_samples_users_column_name': 'user_id',
    'historical_samples_items_column_name': 'item_id'
}

INDUSTRY_SOLUTION_INITIAL_DATASETS = [
    "universe_affinities", "universe_affinities_for_learning", "all_universe_affinities", "universe_scores", "all_universe_affinities_enriched",
    "color_affinities", "color_affinities_for_learning", "all_color_affinities", "color_scores", "all_color_affinities_enriched",
    "type_affinities", "type_affinities_for_learning", "all_type_affinities", "type_scores", "all_type_affinities_enriched",
    "family_affinities", "family_affinities_for_learning", "all_family_affinities", "family_scores", "all_family_affinities_enriched"
]

INDUSTRY_SOLUTION_INITIAL_FLOW_ZONES = [
    "collaborative_filtering|universe", "collaborative_filtering|colors",
    "collaborative_filtering|type", "collaborative_filtering|family"
]