RECIPES_PARAMS = {
    "compute_interactions_prepared":{
        "name":"compute_interactions_prepared",
        "flow_zone": "inputs_preprocessing",
        "params":{
            "steps_indexes":{
                "column_renamings": {
                    "index": 0,
                    "date_renaming_index": 0,
                    "user_id_renaming_index": 1,
                    "item_id_renaming_index": 2,
                    "item_revenue_renaming_index": 3
                }
            }
        }
    },
    "compute_user_metadata_prepared":{
        "name":"compute_user_metadata_prepared",
        "flow_zone": "inputs_preprocessing",
        "params":{
            "steps_indexes":{
                "column_renamings": {
                    "index": 0
                }
            }
        }
    },
    "compute_item_metadata_prepared":{
        "name":"compute_item_metadata_prepared",
        "flow_zone": "inputs_preprocessing",
        "params":{
            "steps_indexes":{
                "column_renamings": {
                    "index": 0
                }
            }
        }
    },
    "compute_batch_users":{
        "name": "compute_batch_users",
        "flow_zone":"inputs_preprocessing",
        "params":{
            "column_aggregations_mapping": {},
            "bool_compute_global_count": False
        }
    },
    "compute_item_interactions_count":{
        "name": "compute_item_interactions_count",
        "flow_zone":"items_analysis_and_selection",
        "params":{
            "column_aggregations_mapping": {},
            "bool_compute_global_count": True
        }
    },
    "compute_total_interactions":{
        "name": "compute_total_interactions",
        "flow_zone":"items_analysis_and_selection",
        "params":{
            "column_aggregations_mapping": {},
            "bool_compute_global_count": True
        }
    },
    "compute_revenue_by_item":{
        "name": "compute_revenue_by_item",
        "flow_zone":"items_analysis_and_selection",
        "params":{
            "column_aggregations_mapping": {"item_revenue": ["sum"]},
            "bool_compute_global_count": True
        }
    },
    "compute_total_revenue":{
        "name": "compute_total_revenue",
        "flow_zone":"items_analysis_and_selection",
        "params":{
            "column_aggregations_mapping": {"item_revenue": ["sum"]},
            "bool_compute_global_count": True
        }
    },
    "compute_items_kept":{
        "name": "compute_items_kept",
        "flow_zone":"items_analysis_and_selection",
        "params":{
            "default_inputs": ["item_interactions_count_rank", "total_interactions"],
            "optional_input_enrichments": ["item_revenue_rank", "total_revenue"]
        }
    },    
    "compute_distinct_dates":{
        "name": "compute_distinct_dates",
        "flow_zone":"time_split_design",
        "params":{
            "column_aggregations_mapping": {},
            "bool_compute_global_count": False
        }
    },
    "compute_user_daily_interactions":{
        "name": "compute_user_daily_interactions",
        "flow_zone":"users_analysis_and_selection",
        "params":{
            "column_aggregations_mapping": {},
            "bool_compute_global_count": True
        }
    },
    "compute_user_interactions":{
        "name": "compute_user_interactions",
        "flow_zone":"users_analysis_and_selection",
        "params":{
            "column_aggregations_mapping": {"date": ["max"], "item_id": ["countDistinct"]},
            "bool_compute_global_count": True
        }
    },
    "compute_user_item_interactions":{
        "name": "compute_user_item_interactions",
        "flow_zone":"recommendation_split",
        "params":{
            "main_dataset_name": "interactions_filtered_dates",
            "main_dataset_columns_to_select": ["date", "user_id", "item_id"],
            "main_dataset_computed_columns": [
                {'expr': '1',
                 'mode': 'GREL',
                 'name': "join_key_interactions_outliers",
                 'type': "int"}
            ],
            "main_dataset_columns_to_select_alias": {},
            "datasets_to_join_settings": {
                "items_kept": {
                    "join_type": "LEFT",
                    "join_key": ["item_id"],
                    "columns_to_select": ["is_item_to_keep"],
                    "columns_to_select_alias": {},
                    "columns_prefix": ""
                },
                "users_kept":{
                    "join_type": "LEFT",
                    "join_key": ["user_id"],
                    "columns_to_select": ["is_user_to_keep"],
                    "columns_to_select_alias": {},
                    "columns_prefix": ""
                },
                "date_scopes": {
                    "join_type": "LEFT",
                    "join_key": ["date"],
                    "columns_to_select": ["week_scope"],
                    "columns_to_select_alias": {},
                    "columns_prefix": ""
                },
                "user_daily_interactions_windows": {
                    "join_type": "LEFT",
                    "join_key": ["last_interaction_date", "user_id"],
                    "columns_to_select": ["n_interactions", "n_interactions_sum", "last_transaction_rank"],
                    "columns_to_select_alias": {},
                    "columns_prefix": "at_date_user"
                },
                "user_hyperactivity_threshold": {
                    "join_type": "LEFT",
                    "join_key": ["join_key_interactions_outliers"],
                    "columns_to_select": ["total_interactions_outlier_threshold"],
                    "columns_to_select_alias": {},
                    "columns_prefix": "user"
                }
            },
            "optional_datasets_to_join_settings": {
                "batch_users_with_ages_clusters": {
                    "join_type": "LEFT",
                    "join_key": ["user_id"],
                    "columns_to_select": ["user_age", "cluster_labels"],
                    "columns_to_select_alias": {"cluster_labels": "user_age_cluster"},
                    "columns_prefix": ""
                },
                "item_metadata_prepared": {
                    "join_type": "LEFT",
                    "join_key": ["item_id"],
                    "columns_to_select": ["TO_ADAPT_BASED_ON_THE_APPLICATION_SETTINGS"],
                    "columns_to_select_alias": {},
                    "columns_prefix": ""
                }
            },
            "post_join_computed_column_settings": [
                {'mode': 'GREL',
                 'name': 'is_interaction_to_keep',
                 'expr': 'if(at_date_user_n_interactions_sum < user_total_interactions_outlier_threshold, \n\t"True",\n    if(at_date_user_last_transaction_rank == 1, "True", "False")\n \n)',
                 'type': 'string'}
            ],
            "post_join_filter_formula_expression": "( strval('is_item_to_keep') == 'True' ) && ( strval('is_user_to_keep') == 'True' ) && ( strval('is_interaction_to_keep') == 'True' )"
        }
    },
    "compute_user_item_distinct_interactions": {
        "name": "compute_user_item_distinct_interactions",
        "flow_zone":"product_recommendations",
        "params":{
            "column_aggregations_mapping": {},
            "bool_compute_global_count": False
        }
    },
    "compute_ecChnPYm": {
        "name": "compute_ecChnPYm",
        "flow_zone":"webapp_zone",
        "params": {
            "default_input_datasets": [
                "item_similarities",
                "user_top_interaction_predictions",
                "user_item_interactions"
            ]
        }
    }
}