# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
from project_root.dku_utils.core import get_current_project_and_variables

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Read recipe inputs
users_kept = dataiku.Dataset("users_kept")
users_kept_df = users_kept.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
project, variables = get_current_project_and_variables()
app_variables = variables["standard"]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
hyperactive_users_outlier_interactions_threshold = app_variables["hyperactive_users_outlier_interactions_threshold_app"]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
user_hyperactivity_threshold =\
np.quantile(users_kept_df["total_interactions"], q=hyperactive_users_outlier_interactions_threshold)
user_hyperactivity_threshold

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
user_hyperactivity_threshold_df = pd.DataFrame([user_hyperactivity_threshold],
                                                       columns=["total_interactions_outlier_threshold"])

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
hyperactive_users_df = \
users_kept_df[users_kept_df["total_interactions"] > user_hyperactivity_threshold]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
hyperactive_users = dataiku.Dataset("hyperactive_users")
hyperactive_users.write_with_schema(hyperactive_users_df)
user_hyperactivity_threshold_dataset = dataiku.Dataset("user_hyperactivity_threshold")
user_hyperactivity_threshold_dataset.write_with_schema(user_hyperactivity_threshold_df)