# Recommendation challenges


Recommendation engines, and especially collaborative filtering approaches face some challenges:
- **Cold start modeling:** Companies naturally get more and more customers as their business grows. Their product catalog also evolves with time: For example, fashion retailers have almost all their products catalog changing each 1 to 3 months. New customers or new products do not have historical data and patterns consistent enough to model a recommender engine: this problem is known as the *Cold start modeling*.

- **Recommendation problem cardinality:** Companies have thousands, hundreds of thousands and potentially millions of customers. They can also propose a significant amount of products to their customers (from tens to thousands). Combinatorics of the number of users and items often lead to a high problem cardinality, complexifying both the computation of the recommendations and the recommendation engine scalability. 

- **Sparsity:** Each customer tends to only interact with a small sample of the product catalog. New customers only interacted with a few products. Furthermore, some products can be seasonal or ephemeral (on-shot products). Finally, new products will naturally get only a few interaction records. All of these combined makes recorded user-item interactions rare compared to the total number of possible user-item interactions.