# Section presentation

The *Recommendation modeling* section allows configuring how you want to optimize the ***Product Recommendations*** machine learning model and consume some of the insights computed, based on it, by Dataiku DSS.

![product_recommendations_modeling.png](8zDL0BaiQLhA)

## Model optimization strategy
![model_optimization_strategy.png](UeDLYUSQMEOa)
Select here the classification metric you want the model to optimize. The application lets you the choice between:
- **Optimize model 'Precision'**: It means that you will give preference to having a precise model at the risk of missing positive predictions.
- **Optimize model 'Recall'**: It means that you will give preference to having an opportunistic model over a precise model.
- **Optimize model 'F1 Score'**: It is a trade-off between being precise and being opportunistic.

## Model consumption in the dashboard
![model_optimization_in_dashboard.png](o5W9DXSJzXo1)

**Evaluate model performances depending on subgroups of data?**: [Subpopulation analysis](https://knowledge.dataiku.com/latest/courses/machine-learning/explainable-ai/concept-subpopulation-analysis.html) will help to analyze the performances of your model across the item characteristics columns and/or the user age cluster, depending on what you set in your application. 

**Analyze dependencies between model predictions and input features in the dashboard?**: [Partial dependence](https://knowledge.dataiku.com/latest/ml-analytics/model-results/concept-partial-dependence-plot.html) plots will show the dependence of the forecasts on other features (Item affinity scores, Item characteristics affinity scores, user age, user age clusters, etc...). 

⚠️ Enabling this option can significantly increase computation time.
