![flow_zones_macro_view_inputs_preprocessing.png](SeOC3c95XMBZ)

# Flow zone presentation


The [inputs_preprocessing](flow_zone:BcyG4cx) applies some first preprocessing steps to your inputs. 
It is composed of 4 branches:
- The interactions_history branch.
- The user_metadata branch.
- The item_metadata branch.
- The item_pictures branch.

![flow_zone_inputs_preprocessing.png](znwb4emwTy5l)

# Main steps

- interactions_history branch:
    - 1: Recipe [compute_interactions_prepared](recipe:compute_interactions_prepared) applies column renamings on the data so that the application can know which columns from your information system are associated with *users*, *items*, *dates* and optionally *revenue generated by items*. It also applies date normalization steps on your data to have *dates at a daily granularity*.
    - 2: Recipe [compute_interactions_filtered_dates](recipe:compute_interactions_filtered_dates) filters the interactions history on the dates corresponding to the batch boundaries set in the application UI.
    - 3: Recipe [compute_batch_users](recipe:compute_batch_users) computes all distinct users present in the batch set in the application UI;

- user_metadata branch: Recipe [compute_user_metadata_prepared](recipe:compute_user_metadata_prepared) applies column renamings on the data so that the application can know which columns from your information system are associated with *users*  and optionally *user ages*.

- item_metadata branch: Recipe [compute_item_metadata_prepared](recipe:compute_item_metadata_prepared) applies column renamings on the data so that the application can know which columns from your information system are associated with *items*  and optionally: 
    - *Item characteristics* (leveraged for feature engineering).
    - *Item pictures* (leveraged in the [project's webapp](article:22)).

- item_pictures branch: Recipe [compute_oDM9ggqk](recipe:compute_oDM9ggqk) resizes the project pictures and stores them in the folder used by the [project's webapp](article:22).


