![flow_zones_macro_view_inputs_preprocessing.png](RIhyGJPicppG)

# Flow zone presentation


The [items_analysis_and_selection](flow_zone:LvyzLcG) filters the items kept for being candidates in the collaborative filtering process.
Filtering items allows to reduce the recommendation problem cardinality *([Get more explanations on this](article:34))*

![flow_zone_items_analysis_and_selection.png](tGXcGwKufnqq)

# Main steps

The flow zone has ***core branches*** and ***<span style="color:#e0c587">optional branches</span>***, as you can see on the screenshot below :arrow_down:. 
***Core*** and ***<span style="color:#e0c587">optional</span>***  are then merged in recipe [compute_items_kept](recipe:compute_items_kept). 

![flow_zone_items_analysis_and_selection_tags.png](5roPW4ysLeqt)

### Core branches
Core branches are all the time built no matter the application configuration. They are responsible for:
- Computing the total number of interactions recorded, *for  ALL items*,  in the batch (Recipe [compute_total_interactions](recipe:compute_total_interactions)).
- Computing and ranking the total number of interactions recorded, *for  EACH item*, in the batch (Recipes [compute_item_interactions_count](recipe:compute_item_interactions_count) and [compute_item_interactions_count_rank](recipe:compute_item_interactions_count_rank)).

### <span style="color:#e0c587">Optional branches</span>
Optional branches are built if the user wants to leverage *items revenue information* to filter items based on the revenue they generated. They are responsible for:
- Computing the total revenue generated, *for  ALL items*,  in the batch (Recipe [compute_total_revenue](recipe:compute_total_revenue)).
- Computing and ranking the total revenue generated, *for  EACH item*, in the batch (Recipes [compute_revenue_by_item](recipe:compute_revenue_by_item) and [compute_item_revenue_rank](recipe:compute_item_revenue_rank)).

### Core and optional branches merging

Recipe [compute_items_kept](recipe:compute_items_kept) is responsible for computing the items kept or rejected based on the application configuration *([See the corresponding article](article:43))*. 
- If the user chose to filter items based on interactions, the items kept are the ones that had the most interactions. 
- If the user chose to filter items based on revenue, the items kept are the ones that generated the most revenue.

Datasets:
- [items_kept](dataset:items_kept) contains *all the items that are candidates for* the recommendation process, and their interactions (<span style="color:#e0c587">+ optionally "revenue"</span>) distribution information.
- [items_rejected](dataset:items_rejected) contains *all the items that are rejected from* the recommendation process, and their interactions (<span style="color:#e0c587">+ optionally "revenue"</span>) distribution information.
- [all_item_distributions_information](dataset:all_item_distributions_information) contains *all items* and their  interactions (<span style="color:#e0c587">+ optionally "revenue"</span>) distribution information.