![flow_zones_macro_view_product_recommendations.png](9hZhGyQ7kEZo)

# Flow zone presentation

The [product_recommendations](flow_zone:rDmjUdx) zone has the role to handle model training and scoring steps so that we can get a set of product recommendations for customers present in the data batch.

![flow_zone_product_recommendations.png](akZXttKR6uug)


# Main steps

- Dataset [final_machine_learning_set_prepared](dataset:final_machine_learning_set_prepared) is associated with visual analysis [recommendation modeling](analysis:srEIpcVP). This visual analysis allows training the ***Product Recommendations*** model that predicts if a user is likely to purchase an item or not. Once trained, this model is then deployed in the flow as the [recommendation_model](saved_model:TT58nj9o).

- Recipe [compute_user_item_distinct_interactions](recipe:compute_user_item_distinct_interactions) computes all distinct user-item interactions recorded in the batch so that we can later leverage this information to know if a user interacted with an item or not. 

 :arrow_forward: Resulting information is stored in dataset [user_item_distinct_interactions](dataset:user_item_distinct_interactions).
 
 - Recipe [compute_scoring_set_with_past_interaction_data](recipe:compute_scoring_set_with_past_interaction_data) enriches the [scoring_set](dataset:scoring_set) dataset by joining on it datasets: 
     - [user_item_distinct_interactions](dataset:user_item_distinct_interactions).
     - **<span style="color:#e0c587">Optionally</span>** [batch_users_with_ages_clusters](dataset:batch_users_with_ages_clusters) if it has been set to leverage user metadata in the project settings.

 :arrow_forward: Resulting information is stored in dataset [scoring_set_with_past_interaction_data](dataset:scoring_set_with_past_interaction_data).

- Recipe [compute_scoring_set_with_past_interaction_data_prepared](recipe:compute_scoring_set_with_past_interaction_data_prepared) applies some last data preparation on dataset [scoring_set_with_past_interaction_data](dataset:scoring_set_with_past_interaction_data) before batch data is scored by [recommendation_model](saved_model:TT58nj9o). 

- Recipe [score_scoring_set_with_past_interaction_data_prepared](recipe:score_scoring_set_with_past_interaction_data_prepared) uses model [recommendation_model](saved_model:TT58nj9o) to score dataset [scoring_set_with_past_interaction_data](dataset:scoring_set_with_past_interaction_data). 

 :arrow_forward: Resulting information is stored in dataset [user_interaction_predictions](dataset:user_interaction_predictions) that contains user-item interaction predictions.
 
 - Finally, recipe [compute_user_top_interaction_predictions](recipe:compute_user_top_interaction_predictions)  ranks all user recommendations per descending probability, so that we can retrieve the **top N  product recommendations for users** (*"N" being defined in the application*).

