# Flow zones structure 

Below is the graph of the project's flow zones [(Learn more about Flow zones)](https://doc.dataiku.com/dss/latest/flow/zones.html):

![flow.png](nXniYrnOfpop)

Each flow zone is linked to a specific component of your project. 

The project leaves some flexibility in the data sources to process. Thus, some flow zones belong to the flow core while others are optional. The flow overview below :arrow_down: illustrates this.


## Flow overview

This flow overview represents the main steps of the flow: 
- **<span style="color:#28A9DD">1 : Connect  to all inputs.</span>**
- **<span style="color:#F9BD37">2 : Preprocess inputs.</span>**
- **<span style="color:#e0c587">2 bis : [Optionally] Apply clustering on customer ages.</span>**
- **<span style="color:#F9BD37">3 : Split the data between the collaborative filtering set and the machine learning set.</span>**
- **<span style="color:#F9BD37">4 : Apply item-based collaborative filtering between "customers" and "items".</span>**
- **<span style="color:#e0c587">4 bis : [Optionally] Apply item-based collaborative filtering between "customers" and "item characteristics".</span>**
- **<span style="color:#e0c587">4 ter : [Optionally] Apply age feature engineering.</span>**
- **<span style="color:#F9BD37">5 : Gather all machine learning features.</span>**
- **<span style="color:#F9BD37">6 : Apply negative sampling on the data.</span>**
- **<span style="color:#2BAE5C">7 : Recommend items to customers.</span>**
- **<span style="color:#F44335">8 : Build webapp and dashboard elements.</span>**

![flow_zones_macro_view.png](QYbY4rgEnnY6)

Here:
- Steps ***<span style="color:#28A9DD">1</span>,  <span style="color:#F9BD37">2</span>,  <span style="color:#F9BD37">3</span>,  <span style="color:#F9BD37">4</span>,  <span style="color:#F9BD37">5</span>,  <span style="color:#F9BD37">6</span>,  <span style="color:#2BAE5C">7</span>*** and ***<span style="color:#F44335">8</span>*** belong to the flow core mentioned before.
- Steps ***<span style="color:#e0c587">2 bis</span>,  <span style="color:#e0c587">4 bis</span>*** and ***<span style="color:#e0c587">4 ter</span>*** optional flow zones.
- The color code used is the same as the one used for each flow zone so that you can clearly assess what it does and to which perimeter it belongs.
- As it is a macro view, each step can represent one or several flow zones.

## Flow in details

The "Tags" flow view will let you color ([What are flow tags?](https://knowledge.dataiku.com/latest/courses/flow-views-and-actions/flow-views-concept-summary.html#tags)) will let you also easily assess if a flow element (dataset, folder, recipe) belongs: 
- To the core perimeter (***black elements*** on the picture below :arrow_down:).
- To the optional perimeter (***<span style="color:#e0c587">brown-gold elements</span>*** on the picture below :arrow_down:).

![flow_tags.png](bEPPOosDgGx5)

**NOTE:** The flow render can vary depending on the data sources you chose to exploit in your own application. 