import numpy as np


def nest_dataframe_data_to_key_column(dataframe, key_column):
    dataframe_columns = np.array(dataframe.columns)
    key_column_index =  np.where(dataframe_columns == key_column)[0][0]
    columns_to_nest = [column for column in dataframe_columns if column != key_column]
    columns_to_nest_positions = [index for index in range(len(dataframe_columns))
                                              if index != key_column_index]

    nested_data = {}
    for row_data in dataframe.values:
        key_column_value = row_data[key_column_index]
        nested_data[key_column_value] = {}

        for column_position, column_name in zip(columns_to_nest_positions, columns_to_nest):
            nested_data[key_column_value][column_name] = row_data[column_position]

    return nested_data