import shapely
from shapely import wkt
from .polygons import convert_polygon_from_shapely_to_list
from ..feature_engineering.union import union_all_shapely_polygons


def read_multipolygon_string_as_list(string_multipolygon, polygon_format, reverse_coordinates, try_to_union_all_polygons):
    if polygon_format == "wkt":
        shapely_multipolygon = convert_multipolygon_from_wkt_string_to_shapely( string_multipolygon )

        if try_to_union_all_polygons:
            shapely_object = union_all_shapely_polygons(shapely_multipolygon)
            
            # 'shapely_object' can be an instance of a Polygon or a MultiPolygon if polygons are not all connected :
            if isinstance(shapely_object, shapely.geometry.polygon.Polygon):
                result = convert_polygon_from_shapely_to_list(shapely_object, reverse_coordinates)
                result_type = "polygon"

            elif isinstance(shapely_object, shapely.geometry.multipolygon.MultiPolygon):
                result = convert_multipolygon_from_shapely_to_list(shapely_object, reverse_coordinates)
                result_type = "multipolygon"

            else:
                log_message = "Shapely object of type '{}' is not handled !".format(type(shapely_object))
                raise Exception(log_message)

        else:
            result = convert_multipolygon_from_shapely_to_list(shapely_multipolygon, reverse_coordinates)
            result_type = "multipolygon"
            
    else:
        log_message = "'{}' is not handled by this function, use a format in ['wkt']".format(polygon_format)
        raise Exception(log_message)
    return result, result_type


def convert_multipolygon_from_wkt_string_to_shapely(wkt_string_multipolygon):
    shapely_multipolygon = wkt.loads(wkt_string_multipolygon)
    return shapely_multipolygon


def convert_multipolygon_from_shapely_to_list(shapely_multipolygon, reverse_coordinates):
    list_multipolygon = []
    for polygon in shapely_multipolygon:
        list_polygon = convert_polygon_from_shapely_to_list(polygon, reverse_coordinates)
        list_multipolygon.append(list_polygon)
    return list_multipolygon
